/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.hosts.HostPatternValue;
import org.apache.sshd.client.config.hosts.HostPatternsHolder;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.PathUtils;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.io.input.NoCloseReader;
import org.apache.sshd.common.util.io.output.NoCloseOutputStream;

public class HostConfigEntry
extends HostPatternsHolder
implements MutableUserHolder {
    public static final String STD_CONFIG_FILENAME = "config";
    public static final String HOST_CONFIG_PROP = "Host";
    public static final String MATCH_CONFIG_PROP = "Match";
    public static final String HOST_NAME_CONFIG_PROP = "HostName";
    public static final String PORT_CONFIG_PROP = "Port";
    public static final String USER_CONFIG_PROP = "User";
    public static final String PROXY_JUMP_CONFIG_PROP = "ProxyJump";
    public static final String IDENTITY_FILE_CONFIG_PROP = "IdentityFile";
    public static final String CERTIFICATE_FILE_CONFIG_PROP = "CertificateFile";
    public static final String LOCAL_FORWARD_CONFIG_PROP = "LocalForward";
    public static final String REMOTE_FORWARD_CONFIG_PROP = "RemoteForward";
    public static final String SEND_ENV_CONFIG_PROP = "SendEnv";
    public static final String SET_ENV_CONFIG_PROP = "SetEnv";
    public static final String PUBKEY_ACCEPTED_ALGORITHMS_CONFIG_PROP = "PubkeyAcceptedAlgorithms";
    public static final String ADD_KEYS_TO_AGENT_CONFIG_PROP = "AddKeysToAgent";
    public static final String CANONICAL_DOMAINS_CONFIG_PROP = "CanonicalDomains";
    public static final String GLOBAL_KNOWN_HOSTS_CONFIG_PROP = "GlobalKnownHostsFile";
    public static final String USER_KNOWN_HOSTS_CONFIG_PROP = "UserKnownHostsFile";
    public static final String EXCLUSIVE_IDENTITIES_CONFIG_PROP = "IdentitiesOnly";
    public static final boolean DEFAULT_EXCLUSIVE_IDENTITIES = false;
    public static final String IDENTITY_AGENT = "IdentityAgent";
    public static final String MULTI_VALUE_SEPARATORS = " ,";
    public static final char PATH_MACRO_CHAR = '%';
    public static final char LOCAL_HOME_MACRO = 'd';
    public static final char LOCAL_USER_MACRO = 'u';
    public static final char LOCAL_HOST_MACRO = 'l';
    public static final char REMOTE_HOST_MACRO = 'h';
    public static final char REMOTE_USER_MACRO = 'r';
    public static final char REMOTE_PORT_MACRO = 'p';
    public static final Set<String> ADDITIVE_KEYS = Collections.unmodifiableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"CertificateFile", "IdentityFile", "LocalForward", "RemoteForward", "SendEnv", "SetEnv"}));
    public static final Set<String> LIST_KEYS = Collections.unmodifiableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"AddKeysToAgent", "CanonicalDomains", "GlobalKnownHostsFile", "SendEnv", "SetEnv", "UserKnownHostsFile"}));
    public static final Map<String, String> KEY_ALIASES = ((MapEntryUtils.NavigableMapBuilder)MapEntryUtils.NavigableMapBuilder.builder(String.CASE_INSENSITIVE_ORDER).put("PubkeyAcceptedKeyTypes", "PubkeyAcceptedAlgorithms")).concurrent();
    protected String hostPatterns;
    protected final Map<String, List<String>> properties = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

    public HostConfigEntry() {
    }

    public HostConfigEntry(String pattern, String host, int port, String username) {
        this(pattern, host, port, username, null);
    }

    public HostConfigEntry(String pattern, String host, int port, String username, String proxyJump) {
        this.setHost(pattern);
        this.setHostName(host);
        this.setPort(port);
        this.setUsername(username);
        this.setProxyJump(proxyJump);
    }

    public void collate(HostConfigEntry that) {
        if (that == null) {
            return;
        }
        that.properties.forEach((k, l) -> {
            if (ADDITIVE_KEYS.contains(k)) {
                this.properties.computeIfAbsent((String)k, x -> new ArrayList()).addAll(l);
            } else if (!this.properties.containsKey(k)) {
                this.properties.put((String)k, new ArrayList(l));
            }
        });
    }

    public String getHost() {
        return this.hostPatterns;
    }

    public void setHost(String host) {
        this.hostPatterns = host;
        this.setPatterns(HostConfigEntry.parsePatterns(HostConfigEntry.parseConfigValue(host)));
    }

    public void setHost(Collection<String> patterns) {
        this.hostPatterns = GenericUtils.join(ValidateUtils.checkNotNullAndNotEmpty(patterns, "No patterns", new Object[0]), ',');
        this.setPatterns(HostConfigEntry.parsePatterns(patterns));
    }

    public String getHostName() {
        return this.getProperty(HOST_NAME_CONFIG_PROP);
    }

    public void setHostName(String hostName) {
        this.setProperty(HOST_NAME_CONFIG_PROP, hostName);
    }

    public int getPort() {
        String value = this.getProperty(PORT_CONFIG_PROP);
        if (value == null) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    public void setPort(int port) {
        if (port <= 0) {
            this.properties.remove(PORT_CONFIG_PROP);
        } else {
            this.setProperty(PORT_CONFIG_PROP, Integer.toString(port));
        }
    }

    @Override
    public String getUsername() {
        return this.getProperty(USER_CONFIG_PROP);
    }

    @Override
    public void setUsername(String username) {
        this.setProperty(USER_CONFIG_PROP, username);
    }

    public String getProxyJump() {
        return this.getProperty(PROXY_JUMP_CONFIG_PROP);
    }

    public void setProxyJump(String proxyJump) {
        this.setProperty(PROXY_JUMP_CONFIG_PROP, proxyJump);
    }

    public Collection<String> getIdentities() {
        List<String> identities = this.properties.get(IDENTITY_FILE_CONFIG_PROP);
        return identities == null ? Collections.emptyList() : identities;
    }

    public void addIdentity(Path path) {
        this.addIdentity(Objects.requireNonNull(path, "No path").toAbsolutePath().normalize().toString());
    }

    public void addIdentity(String id) {
        ValidateUtils.hasContent(id, "No identity provided");
        this.setProperty(IDENTITY_FILE_CONFIG_PROP, id);
    }

    public void setIdentities(Collection<String> identities) {
        this.properties.remove(IDENTITY_FILE_CONFIG_PROP);
        if (identities != null) {
            identities.forEach(this::addIdentity);
        }
    }

    public boolean isIdentitiesOnly() {
        return ConfigFileReaderSupport.parseBooleanValue(this.getProperty(EXCLUSIVE_IDENTITIES_CONFIG_PROP));
    }

    public void setIdentitiesOnly(boolean identitiesOnly) {
        this.setProperty(EXCLUSIVE_IDENTITIES_CONFIG_PROP, ConfigFileReaderSupport.yesNoValueOf(identitiesOnly));
    }

    public Map<String, List<String>> getProperties() {
        return this.properties;
    }

    public void clear() {
        this.properties.clear();
        this.hostPatterns = null;
        this.setPatterns(new LinkedList<HostPatternValue>());
    }

    public List<String> getValues(String name) {
        List<String> values;
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String alias = KEY_ALIASES.get(key);
        if (alias != null) {
            key = alias;
        }
        return (values = this.properties.get(key)) == null ? null : Collections.unmodifiableList(values);
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        List<String> values = this.getValues(name);
        if (values == null || values.isEmpty()) {
            return defaultValue;
        }
        return values.get(0);
    }

    public void setProperty(String name, String value) {
        if (GenericUtils.isEmpty(value)) {
            this.removeProperty(name);
        } else {
            String key = HostConfigEntry.toKey(name);
            List values = this.properties.computeIfAbsent(key, k -> new ArrayList());
            if (!ADDITIVE_KEYS.contains(key)) {
                values.clear();
            }
            values.add(value);
        }
    }

    public void setProperty(String name, List<String> value) {
        if (GenericUtils.isEmpty(value)) {
            this.removeProperty(name);
        } else {
            String key = HostConfigEntry.toKey(name);
            List values = this.properties.computeIfAbsent(key, k -> new ArrayList());
            values.clear();
            values.addAll(value);
        }
    }

    public List<String> removeProperty(String name) {
        return this.properties.remove(HostConfigEntry.toKey(name));
    }

    public <A extends Appendable> A append(A sb) throws IOException {
        sb.append(HOST_CONFIG_PROP).append(' ').append(ValidateUtils.checkNotNullAndNotEmpty(this.getHost(), "No host pattern")).append(IoUtils.EOL);
        HostConfigEntry.appendNonEmptyProperties(sb, this.getProperties());
        return sb;
    }

    public String toString() {
        return this.getHost() + ": " + this.getUsername() + "@" + this.getHostName() + ":" + this.getPort();
    }

    private static String toKey(String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String alias = KEY_ALIASES.get(key);
        return alias != null ? alias : key;
    }

    public static <A extends Appendable> A appendNonEmptyProperties(A sb, Map<String, List<String>> props) throws IOException {
        if (MapEntryUtils.isEmpty(props)) {
            return sb;
        }
        HostConfigEntry.appendNonEmptyProperty(sb, HOST_NAME_CONFIG_PROP, props.get(HOST_NAME_CONFIG_PROP));
        HostConfigEntry.appendNonEmptyProperty(sb, PORT_CONFIG_PROP, props.get(PORT_CONFIG_PROP));
        HostConfigEntry.appendNonEmptyProperty(sb, USER_CONFIG_PROP, props.get(USER_CONFIG_PROP));
        for (Map.Entry<String, List<String>> entry : props.entrySet()) {
            String key = entry.getKey();
            if (HOST_NAME_CONFIG_PROP.equalsIgnoreCase(key) || PORT_CONFIG_PROP.equalsIgnoreCase(key) || USER_CONFIG_PROP.equalsIgnoreCase(key)) continue;
            HostConfigEntry.appendNonEmptyProperty(sb, key, entry.getValue());
        }
        return sb;
    }

    public static <A extends Appendable> A appendNonEmptyProperty(A sb, String name, List<String> value) throws IOException {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String alias = KEY_ALIASES.get(key);
        if (alias != null) {
            key = alias;
        }
        if (ADDITIVE_KEYS.contains(key)) {
            for (String s : value) {
                if (GenericUtils.isEmpty(s)) continue;
                sb.append("    ").append(key).append(' ');
                if (LOCAL_FORWARD_CONFIG_PROP.equalsIgnoreCase(key) || REMOTE_FORWARD_CONFIG_PROP.equalsIgnoreCase(key)) {
                    String[] parts = s.split(" ", 2);
                    HostConfigEntry.appendValue(sb, parts[0]);
                    if (parts.length > 1) {
                        sb.append(' ');
                        HostConfigEntry.appendValue(sb, parts[1]);
                    }
                } else {
                    HostConfigEntry.appendValue(sb, s);
                }
                sb.append(IoUtils.EOL);
            }
        } else {
            sb.append("    ").append(key).append(' ');
            for (String s : value) {
                if (GenericUtils.isEmpty(s)) continue;
                HostConfigEntry.appendValue(sb, s);
            }
            sb.append(IoUtils.EOL);
        }
        return sb;
    }

    public static <A extends Appendable> A appendValue(A sb, String value) throws IOException {
        if (value.indexOf(32) < 0 && value.indexOf(92) < 0) {
            sb.append(value);
            return sb;
        }
        sb.append('\"');
        int i = 0;
        int end = value.length();
        while (i < end) {
            char ch;
            if ((ch = value.charAt(i++)) == '\"' || ch == '\\') {
                sb.append('\\').append(ch);
                continue;
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb;
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, HostConfigEntry ... entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        return HostConfigEntry.findMatchingEntries(host, Arrays.asList(entries));
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<HostConfigEntry> matches = null;
        for (HostConfigEntry hostConfigEntry : entries) {
            if (!hostConfigEntry.isHostMatch(host, 0)) continue;
            if (matches == null) {
                matches = new ArrayList<HostConfigEntry>(entries.size());
            }
            matches.add(hostConfigEntry);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        return matches;
    }

    public static HostConfigEntryResolver toHostConfigEntryResolver(Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(entries)) {
            return HostConfigEntryResolver.EMPTY;
        }
        return (host, port, lclAddress, username, proxyJump, ctx) -> {
            List<String> certificateFiles;
            Collection<String> identities;
            List<HostConfigEntry> matches = HostConfigEntry.findMatchingEntries(host, entries);
            int numMatches = GenericUtils.size(matches);
            if (numMatches <= 0) {
                return null;
            }
            HostConfigEntry entry = new HostConfigEntry(host, null, port, username);
            for (HostConfigEntry m : matches) {
                entry.collate(m);
            }
            String temp = entry.getHostName();
            if (temp == null || temp.isEmpty()) {
                entry.setHostName(host);
            }
            if ((temp = entry.getUsername()) == null || temp.isEmpty()) {
                entry.setUsername(OsUtils.getCurrentUser());
            }
            if (entry.getPort() < 1) {
                entry.setPort(22);
            }
            if (!GenericUtils.isEmpty(identities = entry.getIdentities())) {
                identities = new ArrayList<String>(identities);
                entry.setIdentities(Collections.emptyList());
                for (String id : identities) {
                    entry.addIdentity(HostConfigEntry.resolveIdentityFilePath(id, entry.getHostName(), entry.getPort(), entry.getUsername()));
                }
            }
            if (!GenericUtils.isEmpty(certificateFiles = entry.getValues(CERTIFICATE_FILE_CONFIG_PROP))) {
                entry.removeProperty(CERTIFICATE_FILE_CONFIG_PROP);
                for (String raw : certificateFiles) {
                    entry.setProperty(CERTIFICATE_FILE_CONFIG_PROP, HostConfigEntry.resolveIdentityFilePath(raw, entry.getHostName(), entry.getPort(), entry.getUsername()));
                }
            }
            return entry;
        };
    }

    public static List<HostConfigEntry> readHostConfigEntries(Path path, OpenOption ... options) throws IOException {
        try (InputStream input = Files.newInputStream(path, options);){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(input, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(input, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(InputStream inStream, boolean okToClose) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inStream, okToClose), StandardCharsets.UTF_8);){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(reader, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(Reader rdr, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(rdr, okToClose));){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(buf);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(BufferedReader rdr) throws IOException {
        HostConfigEntry curEntry = null;
        ArrayList<HostConfigEntry> entries = new ArrayList<HostConfigEntry>();
        int lineNumber = 1;
        String line = rdr.readLine();
        while (line != null) {
            String[] parts;
            String keyword;
            if (!GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line)) && line.charAt(0) != '#' && !(keyword = (parts = line.split(" *[= ]", 2))[0].trim()).isEmpty()) {
                int i = keyword.indexOf(35);
                if (i >= 0) {
                    keyword = keyword.substring(0, i);
                }
                if (!keyword.isEmpty()) {
                    String rest;
                    List<String> values = null;
                    String string = rest = i < 0 && parts.length > 1 ? parts[1].trim() : "";
                    if (!rest.isEmpty()) {
                        values = HostConfigEntry.parseList(rest);
                    }
                    if (HOST_CONFIG_PROP.equalsIgnoreCase(keyword)) {
                        if (GenericUtils.isEmpty(values)) {
                            throw new StreamCorruptedException("Missing host pattern(s) at line " + lineNumber + ": " + line);
                        }
                        if (curEntry != null) {
                            entries.add(curEntry);
                        }
                        curEntry = new HostConfigEntry();
                        curEntry.setHost(values);
                    } else {
                        if (MATCH_CONFIG_PROP.equalsIgnoreCase(keyword)) {
                            throw new StreamCorruptedException("Currently not able to process Match sections");
                        }
                        if (curEntry == null) {
                            curEntry = new HostConfigEntry();
                            curEntry.setHost(Collections.singletonList(ALL_HOSTS_PATTERN));
                        }
                        if (values != null && !values.isEmpty()) {
                            if (LIST_KEYS.contains(keyword)) {
                                if (ADDITIVE_KEYS.contains(keyword)) {
                                    for (String value : values) {
                                        curEntry.setProperty(keyword, value);
                                    }
                                } else {
                                    curEntry.setProperty(keyword, values);
                                }
                            } else if (LOCAL_FORWARD_CONFIG_PROP.equalsIgnoreCase(keyword) || REMOTE_FORWARD_CONFIG_PROP.equalsIgnoreCase(keyword)) {
                                String value = values.get(0);
                                if (values.size() > 1) {
                                    value = value + ' ' + values.get(1);
                                }
                                curEntry.setProperty(keyword, value);
                            } else {
                                curEntry.setProperty(keyword, values.get(0));
                            }
                        }
                    }
                }
            }
            line = rdr.readLine();
            ++lineNumber;
        }
        if (curEntry != null) {
            entries.add(curEntry);
        }
        return entries;
    }

    public static List<String> parseList(String argument) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int length = argument.length();
        while (start < length) {
            char ch = argument.charAt(start);
            if (Character.isWhitespace(ch)) {
                ++start;
                continue;
            }
            if (ch == '#') break;
            start = HostConfigEntry.parseToken(argument, start, length, result);
        }
        return result;
    }

    public static int parseToken(String argument, int from, int to, List<String> result) {
        if (from >= to) {
            return from;
        }
        StringBuilder b = new StringBuilder();
        int i = from;
        boolean escaped = false;
        char quote = '\u0000';
        while (i < to) {
            char ch;
            if ((ch = argument.charAt(i++)) == '\'' || ch == '\"') {
                if (escaped) {
                    b.append(ch);
                    escaped = false;
                    continue;
                }
                if (quote == ch) {
                    quote = '\u0000';
                    continue;
                }
                if (quote == '\u0000') {
                    quote = ch;
                    continue;
                }
                b.append(ch);
                continue;
            }
            if (ch == '#') {
                if (quote == '\u0000') break;
                b.append(ch);
                continue;
            }
            if (ch == ' ') {
                if (quote == '\u0000' && !escaped) break;
                if (quote != '\u0000' && escaped) {
                    b.append('\\');
                }
                b.append(ch);
                escaped = false;
                continue;
            }
            if (ch == '\\') {
                if (escaped) {
                    b.append(ch);
                }
                escaped = !escaped;
                continue;
            }
            if (escaped) {
                b.append('\\');
                escaped = false;
            }
            b.append(ch);
        }
        if (escaped) {
            b.append('\\');
        }
        if (b.length() > 0) {
            result.add(b.toString());
        }
        return i;
    }

    public static void writeHostConfigEntries(Path path, Collection<? extends HostConfigEntry> entries, OpenOption ... options) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, options);){
            HostConfigEntry.writeHostConfigEntries(outputStream, true, entries);
        }
    }

    public static void writeHostConfigEntries(OutputStream outputStream, boolean okToClose, Collection<? extends HostConfigEntry> entries) throws IOException {
        if (GenericUtils.isEmpty(entries)) {
            return;
        }
        try (OutputStreamWriter w = new OutputStreamWriter(NoCloseOutputStream.resolveOutputStream(outputStream, okToClose), StandardCharsets.UTF_8);){
            HostConfigEntry.appendHostConfigEntries(w, entries);
        }
    }

    public static <A extends Appendable> A appendHostConfigEntries(A sb, Collection<? extends HostConfigEntry> entries) throws IOException {
        if (!GenericUtils.isEmpty(entries)) {
            for (HostConfigEntry hostConfigEntry : entries) {
                hostConfigEntry.append(sb);
            }
        }
        return sb;
    }

    public static List<String> parseConfigValue(String value) {
        return HostConfigEntry.parseList(GenericUtils.replaceWhitespaceAndTrim(value));
    }

    public static String resolveIdentityFilePath(String id, String host, int port, String username) throws IOException {
        if (GenericUtils.isEmpty(id)) {
            return id;
        }
        String path = id.replace('/', File.separatorChar);
        String[] elements = GenericUtils.split(path, File.separatorChar);
        StringBuilder sb = new StringBuilder(path.length() + 64);
        for (int index = 0; index < elements.length; ++index) {
            String elem = elements[index];
            if (index > 0) {
                sb.append(File.separatorChar);
            }
            for (int curPos = 0; curPos < elem.length(); ++curPos) {
                char ch = elem.charAt(curPos);
                if (ch == '~') {
                    ValidateUtils.checkTrue(curPos == 0 && index == 0, "Home tilde must be first: %s", (Object)id);
                    PathUtils.appendUserHome(sb);
                    continue;
                }
                if (ch == '%') {
                    ValidateUtils.checkTrue(++curPos < elem.length(), "Missing macro modifier in %s", (Object)id);
                    ch = elem.charAt(curPos);
                    switch (ch) {
                        case '%': {
                            sb.append(ch);
                            break;
                        }
                        case 'd': {
                            ValidateUtils.checkTrue(curPos == 1 && index == 0, "Home macro must be first: %s", (Object)id);
                            PathUtils.appendUserHome(sb);
                            break;
                        }
                        case 'u': {
                            sb.append(OsUtils.getCurrentUser());
                            break;
                        }
                        case 'l': {
                            InetAddress address = Objects.requireNonNull(InetAddress.getLocalHost(), "No local address");
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(address.getHostName(), "No local name"));
                            break;
                        }
                        case 'h': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(host, "No remote host provided"));
                            break;
                        }
                        case 'r': {
                            sb.append(ValidateUtils.hasContent(username, "No remote user provided"));
                            break;
                        }
                        case 'p': {
                            ValidateUtils.checkTrue(port > 0, "Bad remote port value: %d", port);
                            sb.append(port);
                            break;
                        }
                        default: {
                            ValidateUtils.throwIllegalArgumentException("Bad modifier '%s' in %s", String.valueOf(ch), id);
                            break;
                        }
                    }
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public static Path getDefaultHostConfigFile() {
        return LazyDefaultConfigFileHolder.CONFIG_FILE;
    }

    private static final class LazyDefaultConfigFileHolder {
        private static final Path CONFIG_FILE = PublicKeyEntry.getDefaultKeysFolderPath().resolve("config");

        private LazyDefaultConfigFileHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

