/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.impl.AbstractUserManager;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginRequest;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.apache.ftpserver.util.BaseProperties;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUserManager
extends AbstractUserManager {
    private final Logger LOG = LoggerFactory.getLogger(PropertiesUserManager.class);
    private static final String PREFIX = "ftpserver.user.";
    private BaseProperties userDataProp;
    private File userDataFile;
    private URL userUrl;

    public PropertiesUserManager(PasswordEncryptor passwordEncryptor, File userDataFile, String adminName) {
        super(adminName, passwordEncryptor);
        this.loadFromFile(userDataFile);
    }

    public PropertiesUserManager(PasswordEncryptor passwordEncryptor, URL userDataPath, String adminName) {
        super(adminName, passwordEncryptor);
        this.loadFromUrl(userDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(File userDataFile) {
        block9: {
            try {
                this.userDataProp = new BaseProperties();
                if (userDataFile == null) break block9;
                this.LOG.debug("File configured, will try loading");
                if (userDataFile.exists()) {
                    this.userDataFile = userDataFile;
                    this.LOG.debug("File found on file system");
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(userDataFile);
                        this.userDataProp.load(fis);
                    }
                    catch (Throwable throwable) {
                        IoUtils.close(fis);
                        throw throwable;
                    }
                    IoUtils.close(fis);
                    break block9;
                }
                this.LOG.debug("File not found on file system, try loading from classpath");
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(userDataFile.getPath());
                if (is != null) {
                    try {
                        this.userDataProp.load(is);
                        break block9;
                    }
                    finally {
                        IoUtils.close(is);
                    }
                }
                throw new FtpServerConfigurationException("User data file specified but could not be located, neither on the file system or in the classpath: " + userDataFile.getPath());
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Error loading user data file : " + userDataFile, e);
            }
        }
    }

    private void loadFromUrl(URL userDataPath) {
        block5: {
            try {
                this.userDataProp = new BaseProperties();
                if (userDataPath == null) break block5;
                this.LOG.debug("URL configured, will try loading");
                this.userUrl = userDataPath;
                InputStream is = null;
                is = userDataPath.openStream();
                try {
                    this.userDataProp.load(is);
                }
                finally {
                    IoUtils.close(is);
                }
            }
            catch (IOException e) {
                throw new FtpServerConfigurationException("Error loading user data resource : " + userDataPath, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        BaseProperties baseProperties = this.userDataProp;
        synchronized (baseProperties) {
            if (this.userDataFile != null) {
                this.LOG.debug("Refreshing user manager using file: " + this.userDataFile.getAbsolutePath());
                this.loadFromFile(this.userDataFile);
            } else {
                this.LOG.debug("Refreshing user manager using URL: " + this.userUrl.toString());
                this.loadFromUrl(this.userUrl);
            }
        }
    }

    public File getFile() {
        return this.userDataFile;
    }

    public synchronized void save(User usr) throws FtpException {
        if (usr.getName() == null) {
            throw new NullPointerException("User name is null.");
        }
        String thisPrefix = PREFIX + usr.getName() + '.';
        this.userDataProp.setProperty(thisPrefix + "userpassword", this.getPassword(usr));
        String home = usr.getHomeDirectory();
        if (home == null) {
            home = "/";
        }
        this.userDataProp.setProperty(thisPrefix + "homedirectory", home);
        this.userDataProp.setProperty(thisPrefix + "enableflag", usr.getEnabled());
        this.userDataProp.setProperty(thisPrefix + "writepermission", usr.authorize((AuthorizationRequest)new WriteRequest()) != null);
        this.userDataProp.setProperty(thisPrefix + "idletime", usr.getMaxIdleTime());
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        transferRateRequest = (TransferRateRequest)usr.authorize((AuthorizationRequest)transferRateRequest);
        if (transferRateRequest != null) {
            this.userDataProp.setProperty(thisPrefix + "uploadrate", transferRateRequest.getMaxUploadRate());
            this.userDataProp.setProperty(thisPrefix + "downloadrate", transferRateRequest.getMaxDownloadRate());
        } else {
            this.userDataProp.remove(thisPrefix + "uploadrate");
            this.userDataProp.remove(thisPrefix + "downloadrate");
        }
        ConcurrentLoginRequest concurrentLoginRequest = new ConcurrentLoginRequest(0, 0);
        concurrentLoginRequest = (ConcurrentLoginRequest)usr.authorize((AuthorizationRequest)concurrentLoginRequest);
        if (concurrentLoginRequest != null) {
            this.userDataProp.setProperty(thisPrefix + "maxloginnumber", concurrentLoginRequest.getMaxConcurrentLogins());
            this.userDataProp.setProperty(thisPrefix + "maxloginperip", concurrentLoginRequest.getMaxConcurrentLoginsPerIP());
        } else {
            this.userDataProp.remove(thisPrefix + "maxloginnumber");
            this.userDataProp.remove(thisPrefix + "maxloginperip");
        }
        this.saveUserData();
    }

    private void saveUserData() throws FtpException {
        if (this.userDataFile == null) {
            return;
        }
        File dir = this.userDataFile.getAbsoluteFile().getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            String dirName = dir.getAbsolutePath();
            throw new FtpServerConfigurationException("Cannot create directory for user data file : " + dirName);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.userDataFile);
            this.userDataProp.store(fos, "Generated file - don't edit (please)");
        }
        catch (IOException ex) {
            try {
                this.LOG.error("Failed saving user data", (Throwable)ex);
                throw new FtpException("Failed saving user data", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IoUtils.close(fos);
                throw throwable;
            }
        }
        IoUtils.close(fos);
    }

    public void delete(String usrName) throws FtpException {
        String thisPrefix = PREFIX + usrName + '.';
        Enumeration<?> propNames = this.userDataProp.propertyNames();
        ArrayList<String> remKeys = new ArrayList<String>();
        while (propNames.hasMoreElements()) {
            String thisKey = propNames.nextElement().toString();
            if (!thisKey.startsWith(thisPrefix)) continue;
            remKeys.add(thisKey);
        }
        Iterator remKeysIt = remKeys.iterator();
        while (remKeysIt.hasNext()) {
            this.userDataProp.remove(remKeysIt.next());
        }
        this.saveUserData();
    }

    private String getPassword(User usr) {
        String name = usr.getName();
        String password = usr.getPassword();
        if (password != null) {
            password = this.getPasswordEncryptor().encrypt(password);
        } else {
            String blankPassword = this.getPasswordEncryptor().encrypt("");
            if (this.doesExist(name)) {
                String key = PREFIX + name + '.' + "userpassword";
                password = this.userDataProp.getProperty(key, blankPassword);
            } else {
                password = blankPassword;
            }
        }
        return password;
    }

    public String[] getAllUserNames() {
        String suffix = ".homedirectory";
        ArrayList<String> ulst = new ArrayList<String>();
        Enumeration<?> allKeys = this.userDataProp.propertyNames();
        int prefixlen = PREFIX.length();
        int suffixlen = suffix.length();
        while (allKeys.hasMoreElements()) {
            String key = (String)allKeys.nextElement();
            if (!key.endsWith(suffix)) continue;
            String name = key.substring(prefixlen);
            int endIndex = name.length() - suffixlen;
            name = name.substring(0, endIndex);
            ulst.add(name);
        }
        Collections.sort(ulst);
        return ulst.toArray(new String[0]);
    }

    public User getUserByName(String userName) {
        if (!this.doesExist(userName)) {
            return null;
        }
        String baseKey = PREFIX + userName + '.';
        BaseUser user = new BaseUser();
        user.setName(userName);
        user.setEnabled(this.userDataProp.getBoolean(baseKey + "enableflag", true));
        user.setHomeDirectory(this.userDataProp.getProperty(baseKey + "homedirectory", "/"));
        ArrayList<Authority> authorities = new ArrayList<Authority>();
        if (this.userDataProp.getBoolean(baseKey + "writepermission", false)) {
            authorities.add(new WritePermission());
        }
        int maxLogin = this.userDataProp.getInteger(baseKey + "maxloginnumber", 0);
        int maxLoginPerIP = this.userDataProp.getInteger(baseKey + "maxloginperip", 0);
        authorities.add(new ConcurrentLoginPermission(maxLogin, maxLoginPerIP));
        int uploadRate = this.userDataProp.getInteger(baseKey + "uploadrate", 0);
        int downloadRate = this.userDataProp.getInteger(baseKey + "downloadrate", 0);
        authorities.add(new TransferRatePermission(downloadRate, uploadRate));
        user.setAuthorities(authorities);
        user.setMaxIdleTime(this.userDataProp.getInteger(baseKey + "idletime", 0));
        return user;
    }

    public boolean doesExist(String name) {
        String key = PREFIX + name + '.' + "homedirectory";
        return this.userDataProp.containsKey(key);
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            String storedPassword;
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String user = upauth.getUsername();
            String password = upauth.getPassword();
            if (user == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            if ((storedPassword = this.userDataProp.getProperty(PREFIX + user + '.' + "userpassword")) == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (this.getPasswordEncryptor().matches(password, storedPassword)) {
                return this.getUserByName(user);
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        if (authentication instanceof AnonymousAuthentication) {
            if (this.doesExist("anonymous")) {
                return this.getUserByName("anonymous");
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        throw new IllegalArgumentException("Authentication not supported by this user manager");
    }

    public synchronized void dispose() {
        if (this.userDataProp != null) {
            this.userDataProp.clear();
            this.userDataProp = null;
        }
    }
}

