/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintDataFormatResolver
extends OsgiDataFormatResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintDataFormatResolver.class);

    public BlueprintDataFormatResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        DataFormatFactory factory = (DataFormatFactory)context.getRegistry().lookupByNameAndType(".camelBlueprint.dataformatFactory." + name, DataFormatFactory.class);
        if (factory != null) {
            LOG.debug("Found dataformat factory: {} in registry: {}", (Object)name, (Object)factory);
            return factory.newInstance();
        }
        return super.createDataFormat(name, context);
    }
}

