/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.commands;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.system.FrameworkType;
import org.apache.karaf.system.commands.AbstractSystemAction;

@Command(scope="system", name="framework", description="OSGi Framework options.")
public class FrameworkOptions
extends AbstractSystemAction {
    @Option(name="-debug", aliases={"--enable-debug"}, description="Enable debug for the OSGi framework", required=false, multiValued=false)
    boolean debug;
    @Option(name="-nodebug", aliases={"--disable-debug"}, description="Disable debug for the OSGi framework", required=false, multiValued=false)
    boolean nodebug;
    @Argument(name="framework", required=false, description="Name of the OSGi framework to use")
    String framework;

    protected Object doExecute() throws Exception {
        FrameworkType frameworkType;
        if (!this.debug ^ this.nodebug && this.framework == null) {
            System.out.printf("Current OSGi framework is %s%n", this.systemService.getFramework().name());
            return null;
        }
        if (this.framework != null) {
            frameworkType = FrameworkType.valueOf((String)this.framework);
            this.systemService.setFramework(frameworkType);
            System.out.println("Changed OSGi framework to " + frameworkType.toString().toLowerCase() + ". Karaf needs to be restarted to make the change effective");
        }
        if (this.debug) {
            frameworkType = this.systemService.getFramework();
            System.out.printf("Enabling debug for OSGi framework (%s)%n", frameworkType.name());
            this.systemService.setFrameworkDebug(true);
        }
        if (this.nodebug) {
            frameworkType = this.systemService.getFramework();
            System.out.printf("Disabling debug for OSGi framework (%s)%n", frameworkType.name());
            this.systemService.setFrameworkDebug(false);
        }
        return null;
    }
}

