/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.stats.MethodExecStats;
import org.apache.juneau.rest.stats.MethodInvoker;

public class RestOpInvoker
extends MethodInvoker {
    private final RestOpArg[] opArgs;

    public RestOpInvoker(Method m, RestOpArg[] opArgs, MethodExecStats stats) {
        super(m, stats);
        this.opArgs = opArgs;
    }

    public void invoke(RestOpSession opSession) throws Throwable {
        Object[] args = new Object[this.opArgs.length];
        for (int i = 0; i < this.opArgs.length; ++i) {
            ParameterInfo pi = this.inner().getParameter(i);
            try {
                args[i] = this.opArgs[i].resolve(opSession);
                continue;
            }
            catch (BasicHttpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BadRequest((Throwable)e, "Could not resolve parameter {0} of type ''{1}'' on method ''{2}''.", new Object[]{i, pi.getParameterType(), this.getFullName()});
            }
        }
        try {
            RestSession session = opSession.getRestSession();
            RestRequest req = opSession.getRequest();
            RestResponse res = opSession.getResponse();
            Object output = super.invoke(session.getResource(), args);
            Boolean debug = req.getAttribute("Debug").as(Boolean.class).orElse(null);
            if (debug == Boolean.TRUE) {
                session.debug(true);
            } else if (debug == Boolean.FALSE) {
                session.debug(false);
            }
            if (!(this.inner().hasReturnType(Void.TYPE) || !Utils.nn((Object)output) && res.getOutputStreamCalled())) {
                res.setContent(output);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new InternalServerError((Throwable)e, "Error occurred invoking method ''{0}''.", new Object[]{this.inner().getFullName()});
        }
        catch (InvocationTargetException e) {
            RestResponse res = opSession.getResponse();
            Throwable e2 = e.getTargetException();
            res.setStatus(500);
            res.setContent(opSession.getRestContext().convertThrowable(e2));
        }
    }
}

