/*
 * Decompiled with CFR 0.152.
 */
package spark;

import spark.Filter;
import spark.FilterImpl;
import spark.ResponseTransformer;
import spark.ResponseTransformerRouteImpl;
import spark.Route;
import spark.RouteImpl;
import spark.TemplateEngine;
import spark.TemplateViewRoute;
import spark.TemplateViewRouteImpl;
import spark.route.HttpMethod;

abstract class Routable {
    private ResponseTransformer defaultResponseTransformer;

    Routable() {
    }

    protected abstract void addRoute(HttpMethod var1, RouteImpl var2);

    @Deprecated
    protected abstract void addRoute(String var1, RouteImpl var2);

    protected abstract void addFilter(HttpMethod var1, FilterImpl var2);

    @Deprecated
    protected abstract void addFilter(String var1, FilterImpl var2);

    public void get(String path, Route route) {
        this.addRoute(HttpMethod.get, this.createRouteImpl(path, route));
    }

    public void post(String path, Route route) {
        this.addRoute(HttpMethod.post, this.createRouteImpl(path, route));
    }

    public void put(String path, Route route) {
        this.addRoute(HttpMethod.put, this.createRouteImpl(path, route));
    }

    public void patch(String path, Route route) {
        this.addRoute(HttpMethod.patch, this.createRouteImpl(path, route));
    }

    public void delete(String path, Route route) {
        this.addRoute(HttpMethod.delete, this.createRouteImpl(path, route));
    }

    public void head(String path, Route route) {
        this.addRoute(HttpMethod.head, this.createRouteImpl(path, route));
    }

    public void trace(String path, Route route) {
        this.addRoute(HttpMethod.trace, this.createRouteImpl(path, route));
    }

    public void connect(String path, Route route) {
        this.addRoute(HttpMethod.connect, this.createRouteImpl(path, route));
    }

    public void options(String path, Route route) {
        this.addRoute(HttpMethod.options, this.createRouteImpl(path, route));
    }

    public void before(String path, Filter filter) {
        this.addFilter(HttpMethod.before, FilterImpl.create(path, filter));
    }

    public void after(String path, Filter filter) {
        this.addFilter(HttpMethod.after, FilterImpl.create(path, filter));
    }

    public void get(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.get, this.createRouteImpl(path, acceptType, route));
    }

    public void post(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.post, this.createRouteImpl(path, acceptType, route));
    }

    public void put(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.put, this.createRouteImpl(path, acceptType, route));
    }

    public void patch(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.patch, this.createRouteImpl(path, acceptType, route));
    }

    public void delete(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.delete, this.createRouteImpl(path, acceptType, route));
    }

    public void head(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.head, this.createRouteImpl(path, acceptType, route));
    }

    public void trace(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.trace, this.createRouteImpl(path, acceptType, route));
    }

    public void connect(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.connect, this.createRouteImpl(path, acceptType, route));
    }

    public void options(String path, String acceptType, Route route) {
        this.addRoute(HttpMethod.options, this.createRouteImpl(path, acceptType, route));
    }

    public void before(Filter filter) {
        this.addFilter(HttpMethod.before, FilterImpl.create("+/*paths", filter));
    }

    public void after(Filter filter) {
        this.addFilter(HttpMethod.after, FilterImpl.create("+/*paths", filter));
    }

    public void before(String path, String acceptType, Filter filter) {
        this.addFilter(HttpMethod.before, FilterImpl.create(path, acceptType, filter));
    }

    public void after(String path, String acceptType, Filter filter) {
        this.addFilter(HttpMethod.after, FilterImpl.create(path, acceptType, filter));
    }

    public void afterAfter(Filter filter) {
        this.addFilter(HttpMethod.afterafter, FilterImpl.create("+/*paths", filter));
    }

    public void afterAfter(String path, Filter filter) {
        this.addFilter(HttpMethod.afterafter, FilterImpl.create(path, filter));
    }

    public void get(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.get, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void get(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.get, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void post(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.post, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void post(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.post, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void put(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.put, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void put(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.put, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void delete(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.delete, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void delete(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.delete, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void patch(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.patch, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void patch(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.patch, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void head(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.head, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void head(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.head, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void trace(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.trace, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void trace(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.trace, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void connect(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.connect, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void connect(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.connect, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void options(String path, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.options, (RouteImpl)TemplateViewRouteImpl.create(path, route, engine));
    }

    public void options(String path, String acceptType, TemplateViewRoute route, TemplateEngine engine) {
        this.addRoute(HttpMethod.options, (RouteImpl)TemplateViewRouteImpl.create(path, acceptType, route, engine));
    }

    public void get(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.get, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void get(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.get, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void post(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.post, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void post(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.post, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void put(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.put, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void put(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.put, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void delete(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.delete, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void delete(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.delete, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void head(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.head, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void head(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.head, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void connect(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.connect, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void connect(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.connect, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void trace(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.trace, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void trace(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.trace, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void options(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.options, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void options(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.options, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    public void patch(String path, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.patch, (RouteImpl)ResponseTransformerRouteImpl.create(path, route, transformer));
    }

    public void patch(String path, String acceptType, Route route, ResponseTransformer transformer) {
        this.addRoute(HttpMethod.patch, (RouteImpl)ResponseTransformerRouteImpl.create(path, acceptType, route, transformer));
    }

    private RouteImpl createRouteImpl(String path, String acceptType, Route route) {
        if (this.defaultResponseTransformer != null) {
            return ResponseTransformerRouteImpl.create(path, acceptType, route, this.defaultResponseTransformer);
        }
        return RouteImpl.create(path, acceptType, route);
    }

    private RouteImpl createRouteImpl(String path, Route route) {
        if (this.defaultResponseTransformer != null) {
            return ResponseTransformerRouteImpl.create(path, route, this.defaultResponseTransformer);
        }
        return RouteImpl.create(path, route);
    }

    public void defaultResponseTransformer(ResponseTransformer transformer) {
        this.defaultResponseTransformer = transformer;
    }
}

