/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import jline.ConsoleReader;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Login
implements Command {
    private static Log log = LogFactory.getLog(Login.class);
    private String userKey = "user";
    private String passwordKey = "password";
    private String workspaceKey = "workspace";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String anon = "anonymous";
        String user = (String)ctx.get(this.userKey);
        String password = (String)ctx.get(this.passwordKey);
        String workspace = (String)ctx.get(this.workspaceKey);
        if (user == null) {
            user = anon;
        }
        if (password == null || password.equals(anon) && !user.equals(anon)) {
            ConsoleReader reader = new ConsoleReader();
            password = reader.readLine("Password: ", Character.valueOf('\u0000'));
        }
        if (log.isDebugEnabled()) {
            log.debug("logging in as " + user);
        }
        Session session = null;
        Repository repo = CommandHelper.getRepository(ctx);
        SimpleCredentials credentials = new SimpleCredentials(user, password.toCharArray());
        session = workspace == null ? repo.login(credentials) : repo.login(credentials, workspace);
        CommandHelper.setSession(ctx, session);
        CommandHelper.setCurrentNode(ctx, session.getRootNode());
        return false;
    }

    public String getPasswordKey() {
        return this.passwordKey;
    }

    public void setPasswordKey(String passwordKey) {
        this.passwordKey = passwordKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String getWorkspaceKey() {
        return this.workspaceKey;
    }

    public void setWorkspaceKey(String workspaceKey) {
        this.workspaceKey = workspaceKey;
    }
}

