/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.sort;

import java.util.Comparator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Ordering;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.ValueComparator;

public class RowComparator
implements Comparator<Row> {
    private static final ValueComparator comparator = new ValueComparator();
    private final Ordering[] orderings;
    private final OperandEvaluator evaluator;

    public RowComparator(Ordering[] orderings, OperandEvaluator evaluator) {
        this.orderings = orderings;
        this.evaluator = evaluator;
    }

    @Override
    public int compare(Row a, Row b) {
        try {
            for (Ordering ordering : this.orderings) {
                Value[] vb;
                DynamicOperand operand = ordering.getOperand();
                Value[] va = this.evaluator.getValues((Operand)operand, a);
                int d = comparator.compare(va, vb = this.evaluator.getValues((Operand)operand, b));
                if (d == 0) continue;
                if ("jcr.order.descending".equals(ordering.getOrder())) {
                    return -d;
                }
                return d;
            }
            return 0;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to compare rows " + String.valueOf(a) + " and " + String.valueOf(b), e);
        }
    }
}

