/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.Traverser;

public abstract class DatabaseTraverser<R, N extends IMNode<N>>
extends Traverser<R, N> {
    protected boolean collectInternal = false;

    public DatabaseTraverser(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch, PathPatternTree scope) throws MetadataException {
        super(startNode, path, store, isPrefixMatch, scope);
    }

    protected boolean mayTargetNodeType(N node) {
        return this.collectInternal || node.isDatabase();
    }

    protected boolean acceptFullMatchedNode(N node) {
        return node.isDatabase();
    }

    protected boolean acceptInternalMatchedNode(N node) {
        return this.collectInternal && node.isDatabase();
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(N node) {
        return !node.isDatabase();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(N node) {
        return !node.isDatabase();
    }

    public void setCollectInternal(boolean collectInternal) {
        this.collectInternal = collectInternal;
    }
}

