/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogZoneDescriptorSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class ZoneDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogZoneDescriptor> {
        ZoneDescriptorSerializerV2() {
        }

        @Override
        public CatalogZoneDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            CatalogStorageProfilesDescriptor catalogStorageProfilesDescriptor = input.readEntry(CatalogStorageProfilesDescriptor.class);
            int partitions = input.readVarIntAsInt();
            int replicas = input.readVarIntAsInt();
            int quorumSize = input.readVarIntAsInt();
            input.readVarIntAsInt();
            int dataNodesAutoAdjustScaleUp = input.readVarIntAsInt();
            int dataNodesAutoAdjustScaleDown = input.readVarIntAsInt();
            String filter = input.readUTF();
            ConsistencyMode consistencyMode = ConsistencyMode.forId(input.readByte());
            return new CatalogZoneDescriptor(id, name, partitions, replicas, quorumSize, dataNodesAutoAdjustScaleUp, dataNodesAutoAdjustScaleDown, filter, catalogStorageProfilesDescriptor, updateTimestamp, consistencyMode);
        }

        @Override
        public void writeTo(CatalogZoneDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeEntry(descriptor.storageProfiles());
            output.writeVarInt(descriptor.partitions());
            output.writeVarInt(descriptor.replicas());
            output.writeVarInt(descriptor.quorumSize());
            output.writeVarInt(descriptor.dataNodesAutoAdjust());
            output.writeVarInt(descriptor.dataNodesAutoAdjustScaleUp());
            output.writeVarInt(descriptor.dataNodesAutoAdjustScaleDown());
            output.writeUTF(descriptor.filter());
            output.writeByte(descriptor.consistencyMode().id());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class ZoneDescriptorSerializerV1
    implements CatalogObjectSerializer<CatalogZoneDescriptor> {
        private final CatalogEntrySerializerProvider serializers;

        public ZoneDescriptorSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogZoneDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            input.readVarInt();
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_STORAGE_PROFILES.id());
            CatalogStorageProfilesDescriptor catalogStorageProfilesDescriptor = (CatalogStorageProfilesDescriptor)serializer.readFrom(input);
            int partitions = input.readVarIntAsInt();
            int replicas = input.readVarIntAsInt();
            int dataNodesAutoAdjust = input.readVarIntAsInt();
            int dataNodesAutoAdjustScaleUp = input.readVarIntAsInt();
            int dataNodesAutoAdjustScaleDown = input.readVarIntAsInt();
            String filter = input.readUTF();
            ConsistencyMode consistencyMode = ConsistencyMode.forId(input.readByte());
            return new CatalogZoneDescriptor(id, name, partitions, replicas, CatalogUtils.defaultQuorumSize(replicas), dataNodesAutoAdjust, dataNodesAutoAdjustScaleUp, dataNodesAutoAdjustScaleDown, filter, catalogStorageProfilesDescriptor, CatalogManager.INITIAL_TIMESTAMP, consistencyMode);
        }

        @Override
        public void writeTo(CatalogZoneDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            CatalogStorageProfilesDescriptor storageProfilesDescriptor = descriptor.storageProfiles();
            this.serializers.get(1, storageProfilesDescriptor.typeId()).writeTo(storageProfilesDescriptor, output);
            output.writeVarInt(descriptor.partitions());
            output.writeVarInt(descriptor.replicas());
            output.writeVarInt(descriptor.dataNodesAutoAdjust());
            output.writeVarInt(descriptor.dataNodesAutoAdjustScaleUp());
            output.writeVarInt(descriptor.dataNodesAutoAdjustScaleDown());
            output.writeUTF(descriptor.filter());
            output.writeByte(descriptor.consistencyMode().id());
        }
    }
}

