/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class PartitionModificationCounter {
    private final LongSupplier partitionSizeSupplier;
    private final double staleRowsFraction;
    private final long minStaleRowsCount;
    private final AtomicLong counter = new AtomicLong(0L);
    private volatile long nextMilestone;
    private volatile HybridTimestamp lastMilestoneReachedTimestamp;

    public PartitionModificationCounter(HybridTimestamp initTimestamp, LongSupplier partitionSizeSupplier, double staleRowsFraction, long minStaleRowsCount) {
        Objects.requireNonNull(initTimestamp, "initTimestamp");
        Objects.requireNonNull(partitionSizeSupplier, "partitionSizeSupplier");
        if (staleRowsFraction < 0.0 || staleRowsFraction > 1.0) {
            throw new IllegalArgumentException("staleRowsFraction must be in [0, 1] range");
        }
        if (minStaleRowsCount < 0L) {
            throw new IllegalArgumentException("minStaleRowsCount must be non-negative");
        }
        this.staleRowsFraction = staleRowsFraction;
        this.minStaleRowsCount = minStaleRowsCount;
        this.partitionSizeSupplier = partitionSizeSupplier;
        this.nextMilestone = PartitionModificationCounter.computeNextMilestone(partitionSizeSupplier.getAsLong(), staleRowsFraction, minStaleRowsCount);
        this.lastMilestoneReachedTimestamp = initTimestamp;
    }

    public long value() {
        return this.counter.get();
    }

    public HybridTimestamp lastMilestoneTimestamp() {
        return this.lastMilestoneReachedTimestamp;
    }

    public long nextMilestone() {
        return this.nextMilestone;
    }

    public void updateValue(int delta, HybridTimestamp commitTimestamp) {
        Objects.requireNonNull(commitTimestamp, "commitTimestamp");
        if (delta < 0) {
            throw new IllegalArgumentException("Delta must be non-negative.");
        }
        if (delta == 0) {
            return;
        }
        long newCounter = this.counter.addAndGet(delta);
        if (newCounter >= this.nextMilestone) {
            this.nextMilestone = newCounter + PartitionModificationCounter.computeNextMilestone(this.partitionSizeSupplier.getAsLong(), this.staleRowsFraction, this.minStaleRowsCount);
            this.lastMilestoneReachedTimestamp = commitTimestamp;
        }
    }

    private static long computeNextMilestone(long currentSize, double staleRowsFraction, long minStaleRowsCount) {
        return Math.max((long)((double)currentSize * staleRowsFraction), minStaleRowsCount);
    }
}

