/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.ignite.internal.util.GridUnsafe;

public class StringIntrospection {
    private static final boolean USE_UNSAFE_TO_GET_LATIN1_BYTES;
    private static final long STRING_CODER_FIELD_OFFSET;
    private static final long STRING_VALUE_FIELD_OFFSET;
    private static final byte LATIN1 = 0;
    private static final long NO_OFFSET = Long.MIN_VALUE;

    private static Optional<Boolean> compactStrings() {
        return StringIntrospection.compactStringsField().map(field -> {
            try {
                return (Boolean)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Should not be thrown", e);
            }
        });
    }

    private static Optional<Field> compactStringsField() {
        return StringIntrospection.stringField("COMPACT_STRINGS").map(field -> {
            field.setAccessible(true);
            return field;
        });
    }

    private static Optional<Field> stringField(String name) {
        try {
            return Optional.of(String.class.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    private static Optional<Long> coderFieldOffset() {
        return StringIntrospection.stringField("coder").map(GridUnsafe::objectFieldOffset);
    }

    private static Optional<Long> byteValueFieldOffset() {
        return StringIntrospection.stringField("value").filter(field -> field.getType() == byte[].class).map(GridUnsafe::objectFieldOffset);
    }

    public static boolean supportsFastGetLatin1Bytes(String str) {
        if (!USE_UNSAFE_TO_GET_LATIN1_BYTES) {
            return false;
        }
        return GridUnsafe.getByteField(str, STRING_CODER_FIELD_OFFSET) == 0;
    }

    public static byte[] fastAsciiBytes(String str) {
        if (STRING_VALUE_FIELD_OFFSET != Long.MIN_VALUE) {
            return (byte[])GridUnsafe.getObjectField(str, STRING_VALUE_FIELD_OFFSET);
        }
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] fastLatin1Bytes(String str) {
        if (STRING_VALUE_FIELD_OFFSET != Long.MIN_VALUE) {
            return (byte[])GridUnsafe.getObjectField(str, STRING_VALUE_FIELD_OFFSET);
        }
        return str.getBytes(StandardCharsets.ISO_8859_1);
    }

    private StringIntrospection() {
    }

    static {
        Optional<Boolean> maybeCompactStrings = StringIntrospection.compactStrings();
        Optional<Long> maybeCoderFieldOffset = StringIntrospection.coderFieldOffset();
        USE_UNSAFE_TO_GET_LATIN1_BYTES = maybeCompactStrings.isPresent() && maybeCoderFieldOffset.isPresent();
        STRING_CODER_FIELD_OFFSET = maybeCoderFieldOffset.orElse(Long.MIN_VALUE);
        Optional<Long> maybeValueFieldOffset = StringIntrospection.byteValueFieldOffset();
        STRING_VALUE_FIELD_OFFSET = maybeValueFieldOffset.orElse(Long.MIN_VALUE);
    }
}

