/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.util.Commons;

class ParsingPhaseHandler
implements ExecutionPhaseHandler {
    static final ExecutionPhaseHandler INSTANCE = new ParsingPhaseHandler();

    private ParsingPhaseHandler() {
    }

    @Override
    public Result handle(Query query) {
        ParsedResult parsedResult = query.executor.lookupParsedResultInCache(query.sql);
        if (parsedResult != null) {
            query.parsedResult = parsedResult;
            return Result.completed();
        }
        CompletableFuture<Void> awaitFuture = new CompletableFuture<Void>();
        query.executor.execute(() -> {
            try {
                ParsedResult result;
                if (Commons.isMultiStatementQueryAllowed(query.properties)) {
                    List<ParsedResult> results = query.executor.parseScript(query.sql);
                    if (results.size() != 1 || results.get(0).queryType() == SqlQueryType.TX_CONTROL) {
                        query.parsedScript = results;
                        awaitFuture.complete(null);
                        return;
                    }
                    result = results.get(0);
                } else {
                    result = query.executor.parse(query.sql);
                }
                if (result.queryType().supportsParseResultCaching()) {
                    query.executor.updateParsedResultCache(query.sql, result);
                }
                query.parsedResult = result;
                awaitFuture.complete(null);
            }
            catch (Throwable th) {
                awaitFuture.completeExceptionally(th);
            }
        });
        return Result.proceedAfter(awaitFuture);
    }
}

