/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp.agg;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Set;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;

public class AggregateRow<RowT> {
    public static final byte NO_GROUP_ID = -1;
    private final AccumulatorsState state;
    private final Int2ObjectMap<Set<Object>> distinctSets;

    public AggregateRow(AccumulatorsState state, Int2ObjectMap<Set<Object>> distinctSets) {
        this.state = state;
        this.distinctSets = distinctSets;
    }

    public static boolean addEmptyGroup(ImmutableBitSet groupKeys, AggregateType type) {
        return groupKeys.isEmpty() && (type == AggregateType.REDUCE || type == AggregateType.SINGLE);
    }

    public static <RowT> boolean groupMatches(RowHandler<RowT> handler, RowT row, AggregateType type, byte groupId) {
        if (type == AggregateType.REDUCE) {
            int columnCount = handler.columnCount(row);
            byte targetGroupId = (Byte)handler.get(columnCount - 1, row);
            return targetGroupId == groupId;
        }
        return groupId != -1;
    }

    public void update(List<AccumulatorWrapper<RowT>> accs, ImmutableBitSet grpFields, RowHandler<RowT> handler, RowT row) {
        for (int i = 0; i < accs.size(); ++i) {
            AccumulatorWrapper<RowT> acc = accs.get(i);
            Object[] args = acc.getArguments(row);
            if (args == null) continue;
            this.state.setIndex(i);
            if (acc.isGrouping()) {
                this.state.set(grpFields);
            } else if (acc.isDistinct()) {
                Set distinctSet = (Set)this.distinctSets.get(i);
                distinctSet.add(args[0]);
            } else {
                acc.accumulator().add(this.state, args);
            }
            this.state.resetIndex();
        }
    }

    public Object[] createOutput(AggregateType type, List<AccumulatorWrapper<RowT>> accs, ImmutableBitSet allFields, byte groupId) {
        int extra = groupId == -1 || type != AggregateType.MAP ? 0 : 1;
        int rowSize = allFields.cardinality() + accs.size() + extra;
        return new Object[rowSize];
    }

    public void writeTo(AggregateType type, List<AccumulatorWrapper<RowT>> accs, Object[] output, int offset, ImmutableBitSet groupFields, byte groupId) {
        AccumulatorsState result = new AccumulatorsState(accs.size());
        for (int i = 0; i < accs.size(); ++i) {
            AccumulatorWrapper<RowT> acc = accs.get(i);
            this.state.setIndex(i);
            result.setIndex(i);
            if (acc.isDistinct()) {
                assert (!acc.isGrouping());
                Set distinctSet = (Set)this.distinctSets.get(i);
                for (Object arg : distinctSet) {
                    acc.accumulator().add(this.state, new Object[]{arg});
                }
            }
            acc.accumulator().end(this.state, result);
            output[i + offset] = acc.convertResult(result.get());
            this.state.resetIndex();
            result.resetIndex();
        }
        if (groupId != -1 && type == AggregateType.MAP) {
            output[output.length - 1] = groupId;
        }
    }
}

