/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class JobExecutionWrapper<R>
implements JobExecution<R>,
MarshallerProvider<R> {
    private final JobExecution<R> delegate;

    JobExecutionWrapper(JobExecution<R> delegate) {
        this.delegate = delegate;
    }

    public CompletableFuture<R> resultAsync() {
        return ComputeUtils.convertToComputeFuture(this.delegate.resultAsync());
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.stateAsync());
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.changePriorityAsync(newPriority));
    }

    public ClusterNode node() {
        return this.delegate.node();
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        if (this.delegate instanceof MarshallerProvider) {
            return ((MarshallerProvider)this.delegate).resultMarshaller();
        }
        return null;
    }

    @Override
    public boolean marshalResult() {
        return this.delegate instanceof MarshallerProvider && ((MarshallerProvider)this.delegate).marshalResult();
    }
}

