/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.jetbrains.annotations.Nullable;

class SegmentFile
implements ManuallyCloseable {
    static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final int CLOSED_POS_MARKER = -1;
    private final MappedByteBuffer buffer;
    private final AtomicInteger bufferPosition = new AtomicInteger();
    private final AtomicInteger numWriters = new AtomicInteger();

    SegmentFile(Path path, long fileSize, long position) throws IOException {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("File size is negative: " + fileSize);
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Position is negative: " + position);
        }
        if (position >= fileSize) {
            throw new IllegalArgumentException("Position is greater than file size: " + position + ", fileSize: " + fileSize);
        }
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File size is too big: " + fileSize);
        }
        try (RandomAccessFile file = SegmentFile.openFile(path, fileSize, position);){
            this.buffer = file.getChannel().map(FileChannel.MapMode.READ_WRITE, position, fileSize - position);
        }
    }

    private static RandomAccessFile openFile(Path path, long fileSize, long position) throws IOException {
        if (position != 0L) {
            return new RandomAccessFile(path.toFile(), "rw");
        }
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        RandomAccessFile file = new RandomAccessFile(path.toFile(), "rw");
        file.setLength(fileSize);
        return file;
    }

    void closeForRollover(byte[] bytesToWrite) {
        this.close(bytesToWrite);
    }

    public void close() {
        this.close(null);
    }

    private void close(byte @Nullable [] bytesToWrite) {
        int pos = this.bufferPosition.getAndSet(-1);
        if (pos == -1) {
            return;
        }
        while (this.numWriters.get() > 0) {
            Thread.onSpinWait();
        }
        if (bytesToWrite != null && pos + bytesToWrite.length <= this.buffer.limit()) {
            this.slice(pos, bytesToWrite.length).put(bytesToWrite);
        }
    }

    @Nullable
    WriteBuffer reserve(int size) {
        this.numWriters.incrementAndGet();
        try {
            ByteBuffer slice = this.reserveBytes(size);
            if (slice == null) {
                this.numWriters.decrementAndGet();
                return null;
            }
            return new WriteBuffer(slice);
        }
        catch (Throwable e) {
            this.numWriters.decrementAndGet();
            throw e;
        }
    }

    void sync() {
        this.buffer.force();
    }

    @Nullable
    private ByteBuffer reserveBytes(int size) {
        int nextPos;
        int pos;
        do {
            if ((pos = this.bufferPosition.get()) == -1) {
                return null;
            }
            nextPos = pos + size;
            if (nextPos <= this.buffer.limit()) continue;
            return null;
        } while (!this.bufferPosition.compareAndSet(pos, nextPos));
        return this.slice(pos, size);
    }

    private ByteBuffer slice(int pos, int size) {
        return this.buffer.duplicate().order(BYTE_ORDER).position(pos).limit(pos + size);
    }

    class WriteBuffer
    implements AutoCloseable {
        private final ByteBuffer slice;

        WriteBuffer(ByteBuffer slice) {
            this.slice = slice;
        }

        ByteBuffer buffer() {
            return this.slice;
        }

        @Override
        public void close() {
            SegmentFile.this.numWriters.decrementAndGet();
        }
    }
}

