/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest;

import com.fasterxml.jackson.databind.DeserializationFeature;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.runtime.Micronaut;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.netty.handler.ssl.ClientAuth;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.configuration.KeyStoreView;
import org.apache.ignite.internal.rest.RestFactory;
import org.apache.ignite.internal.rest.RestManager;
import org.apache.ignite.internal.rest.RestState;
import org.apache.ignite.internal.rest.configuration.RestConfiguration;
import org.apache.ignite.internal.rest.configuration.RestSslView;
import org.apache.ignite.internal.rest.configuration.RestView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class RestComponent
implements IgniteComponent {
    private static final Object SHARED_STARTUP_LOCK = new Object();
    private static final int UNAVAILABLE_PORT = -1;
    private static final String LOCALHOST = "localhost";
    private static final IgniteLogger LOG = Loggers.forClass(RestComponent.class);
    private final List<Supplier<RestFactory>> restFactories;
    private final RestConfiguration restConfiguration;
    private final RestManager restManager;
    private volatile ApplicationContext context;
    private volatile int httpPort = -1;
    private volatile int httpsPort = -1;

    public RestComponent(List<Supplier<RestFactory>> restFactories, RestManager restManager, RestConfiguration restConfiguration) {
        this.restFactories = restFactories;
        this.restConfiguration = restConfiguration;
        this.restManager = restManager;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        RestView restConfigurationView = (RestView)this.restConfiguration.value();
        RestSslView sslConfigurationView = restConfigurationView.ssl();
        boolean sslEnabled = sslConfigurationView.enabled();
        boolean dualProtocol = (Boolean)this.restConfiguration.dualProtocol().value();
        if (this.startServer(restConfigurationView.port(), sslConfigurationView.port(), sslEnabled, dualProtocol)) {
            return CompletableFutures.nullCompletedFuture();
        }
        String msg = "Cannot start REST endpoint. Couldn't find available port for HTTP or HTTPS [HTTP port=" + this.httpPort + "], [HTTPS port=" + this.httpsPort + "]";
        LOG.error(msg, new Object[0]);
        throw new IgniteException(ErrorGroups.Common.COMPONENT_NOT_STARTED_ERR, msg);
    }

    public void disable() {
        this.restManager.setState(RestState.INITIALIZATION);
    }

    public void enable() {
        this.restManager.setState(RestState.INITIALIZED);
    }

    private boolean startServer(int httpPortCandidate, int httpsPortCandidate, boolean sslEnabled, boolean dualProtocol) {
        Object object = SHARED_STARTUP_LOCK;
        synchronized (object) {
            try {
                this.httpPort = httpPortCandidate;
                this.httpsPort = httpsPortCandidate;
                this.context = this.buildMicronautContext(httpPortCandidate, httpsPortCandidate).deduceEnvironment(Boolean.valueOf(false)).environments(new String[]{"baremetal"}).start();
                this.logSuccessRestStart(sslEnabled, dualProtocol);
                return true;
            }
            catch (ApplicationStartupException e) {
                BindException bindException = this.findBindException(e);
                if (bindException != null) {
                    return false;
                }
                throw new IgniteException(ErrorGroups.Common.COMPONENT_NOT_STARTED_ERR, (Throwable)e);
            }
        }
    }

    private void logSuccessRestStart(boolean sslEnabled, boolean dualProtocol) {
        String successReportMsg = sslEnabled && dualProtocol ? "[httpPort=" + this.httpPort + "], [httpsPort=" + this.httpsPort + "]" : (sslEnabled ? "[httpsPort=" + this.httpsPort + "]" : "[httpPort=" + this.httpPort + "]");
        LOG.info("REST server started successfully: " + successReportMsg, new Object[0]);
    }

    @Nullable
    private BindException findBindException(ApplicationStartupException e) {
        for (Throwable throwable = e.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof BindException)) continue;
            return (BindException)throwable;
        }
        return null;
    }

    private Micronaut buildMicronautContext(int portCandidate, int sslPortCandidate) {
        Micronaut micronaut = new IgniteMicronaut().args(new String[]{""});
        this.setFactories(micronaut);
        return micronaut.properties(this.serverProperties(portCandidate, sslPortCandidate)).banner(false).mapError(ServerStartupException.class, ex -> -1).mapError(ApplicationStartupException.class, ex -> -1);
    }

    private void setFactories(Micronaut micronaut) {
        for (Supplier<RestFactory> factory : this.restFactories) {
            micronaut.singletons(new Object[]{factory.get()});
        }
    }

    private Map<String, Object> serverProperties(int port, int sslPort) {
        RestSslView restSslView = (RestSslView)this.restConfiguration.ssl().value();
        boolean sslEnabled = restSslView.enabled();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("micronaut.server.port", port);
        result.put("micronaut.server.cors.enabled", "true");
        result.put("micronaut.server.cors.configurations.web.allowed-headers", "Authorization");
        result.put("micronaut.security.intercept-url-map[0].pattern", "/**");
        result.put("micronaut.security.intercept-url-map[0].access", "isAuthenticated()");
        result.put("micronaut.server.max-request-size", Integer.MAX_VALUE);
        result.put("micronaut.server.multipart.max-file-size", Integer.MAX_VALUE);
        result.put("jackson.deserialization", Map.of(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true));
        if (sslEnabled) {
            KeyStoreView keyStore = restSslView.keyStore();
            boolean dualProtocol = (Boolean)this.restConfiguration.dualProtocol().value();
            result.put("micronaut.server.dual-protocol", dualProtocol);
            result.put("micronaut.server.ssl.port", sslPort);
            if (!restSslView.ciphers().isBlank()) {
                result.put("micronaut.server.ssl.ciphers", restSslView.ciphers());
            }
            result.put("micronaut.server.ssl.enabled", sslEnabled);
            result.put("micronaut.server.ssl.key-store.path", "file:" + keyStore.path());
            result.put("micronaut.server.ssl.key-store.password", keyStore.password());
            result.put("micronaut.server.ssl.key-store.type", keyStore.type());
            ClientAuth clientAuth = ClientAuth.valueOf((String)restSslView.clientAuth().toUpperCase());
            if (ClientAuth.NONE == clientAuth) {
                return result;
            }
            KeyStoreView trustStore = restSslView.trustStore();
            result.put("micronaut.server.ssl.client-authentication", RestComponent.toMicronautClientAuth(clientAuth));
            result.put("micronaut.server.ssl.trust-store.path", "file:" + trustStore.path());
            result.put("micronaut.server.ssl.trust-store.password", trustStore.password());
            result.put("micronaut.server.ssl.trust-store.type", trustStore.type());
        }
        return result;
    }

    private static String toMicronautClientAuth(ClientAuth clientAuth) {
        switch (clientAuth) {
            case OPTIONAL: {
                return ClientAuthentication.WANT.name().toLowerCase();
            }
            case REQUIRE: {
                return ClientAuthentication.NEED.name().toLowerCase();
            }
        }
        throw new IllegalArgumentException("Can not convert " + clientAuth.name() + " to micronaut type");
    }

    public synchronized CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (this.context != null) {
            this.context.stop();
            this.context = null;
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public int httpPort() {
        RestView restView = (RestView)this.restConfiguration.value();
        if (!restView.ssl().enabled() || restView.dualProtocol()) {
            return this.httpPort;
        }
        return -1;
    }

    public int httpsPort() {
        RestView restView = (RestView)this.restConfiguration.value();
        if (restView.ssl().enabled()) {
            return this.httpsPort;
        }
        return -1;
    }

    public String hostName() {
        if (this.context == null) {
            throw new IgniteInternalException("RestComponent has not been started");
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return LOCALHOST;
        }
    }

    private static class IgniteMicronaut
    extends Micronaut {
        private final ConversionService conversionService = new DefaultConversionService();

        private IgniteMicronaut() {
        }

        protected ApplicationContext newApplicationContext() {
            return new DefaultApplicationContext((ApplicationContextConfiguration)this){

                protected ConversionService createConversionService() {
                    return conversionService;
                }
            };
        }

        public ConversionService<?> getConversionService() {
            return this.conversionService;
        }
    }
}

