/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.table.mapper;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.table.mapper.PojoMapper;
import org.apache.ignite.shaded.org.apache.ignite.table.mapper.TypeConverter;

class PojoMapperImpl<T>
implements PojoMapper<T> {
    private final Class<T> targetType;
    private final Map<String, String> mapping;
    private final Map<String, TypeConverter<?, ?>> converters;

    PojoMapperImpl(Class<T> targetType, Map<String, String> mapping, Map<String, TypeConverter<?, ?>> converters) {
        this.converters = converters;
        if (Objects.requireNonNull(mapping).isEmpty()) {
            throw new IllegalArgumentException("Empty mapping isn't allowed.");
        }
        this.targetType = targetType;
        this.mapping = mapping;
    }

    @Override
    public Class<T> targetType() {
        return this.targetType;
    }

    @Override
    public String fieldForColumn(String columnName) {
        return this.mapping.get(columnName);
    }

    @Override
    public Collection<String> fields() {
        return this.mapping.values();
    }

    @Override
    public <FieldT, ColumnT> TypeConverter<FieldT, ColumnT> converterForColumn(String columnName) {
        return this.converters.get(columnName);
    }
}

