/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.hlc;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.ClockWaiter;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.Loggers;

public class ClockServiceImpl
implements ClockService {
    private final IgniteLogger log = Loggers.forClass(ClockServiceImpl.class);
    private final HybridClock clock;
    private final ClockWaiter clockWaiter;
    private final LongSupplier maxClockSkewMsSupplier;
    private final Consumer<Long> onMaxClockSkewExceededClosure;
    private volatile long maxClockSkewMillis = -1L;

    public ClockServiceImpl(HybridClock clock, ClockWaiter clockWaiter, LongSupplier maxClockSkewMsSupplier, Consumer<Long> onMaxClockSkewExceededClosure) {
        this.clock = clock;
        this.clockWaiter = clockWaiter;
        this.maxClockSkewMsSupplier = maxClockSkewMsSupplier;
        this.onMaxClockSkewExceededClosure = onMaxClockSkewExceededClosure;
    }

    @Override
    public HybridTimestamp now() {
        return this.clock.now();
    }

    @Override
    public HybridTimestamp current() {
        return this.clock.current();
    }

    @Override
    public long nowLong() {
        return this.clock.nowLong();
    }

    @Override
    public long currentLong() {
        return this.clock.currentLong();
    }

    @Override
    public HybridTimestamp updateClock(HybridTimestamp requestTime) {
        HybridTimestamp currentLocalTimestamp = this.clock.current();
        long requestTimePhysical = requestTime.getPhysical();
        long currentLocalTimePhysical = currentLocalTimestamp.getPhysical();
        if (requestTimePhysical - this.maxClockSkewMillis() > currentLocalTimePhysical) {
            this.log.warn("Maximum allowed clock drift exceeded [requestTime={}, localTime={}, maxClockSkew={}]", requestTime, currentLocalTimestamp, this.maxClockSkewMillis());
            this.onMaxClockSkewExceededClosure.accept(requestTimePhysical - currentLocalTimePhysical);
        }
        return this.clock.update(requestTime);
    }

    @Override
    public CompletableFuture<Void> waitFor(HybridTimestamp targetTimestamp) {
        return this.clockWaiter.waitFor(targetTimestamp);
    }

    @Override
    public long maxClockSkewMillis() {
        if (this.maxClockSkewMillis == -1L) {
            this.maxClockSkewMillis = this.maxClockSkewMsSupplier.getAsLong();
        }
        return this.maxClockSkewMillis;
    }
}

