/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.helix.task.beans.ScheduleBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleConfig.class);
    private static final long MIN_RECURRENCE_MILLIS = 60000L;
    private final Date _startTime;
    private final TimeUnit _recurUnit;
    private final Long _recurInterval;

    private ScheduleConfig(Date startTime, TimeUnit recurUnit, Long recurInterval) {
        this._startTime = startTime;
        this._recurUnit = recurUnit;
        this._recurInterval = recurInterval;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public TimeUnit getRecurrenceUnit() {
        return this._recurUnit;
    }

    public Long getRecurrenceInterval() {
        return this._recurInterval;
    }

    public boolean isRecurring() {
        return this._recurUnit != null && this._recurInterval != null;
    }

    public boolean isValid() {
        long converted;
        if (this._startTime == null) {
            LOG.error("All schedules must have a start time!");
            return false;
        }
        if (this._recurUnit == null && this._recurInterval != null || this._recurUnit != null && this._recurInterval == null) {
            LOG.error("Recurrence interval and unit must either both be present or both be absent");
            return false;
        }
        if (this._recurInterval != null && this._recurInterval <= 0L) {
            LOG.error("Recurrence interval must be positive");
            return false;
        }
        if (this._recurUnit != null && (converted = this._recurUnit.toMillis(this._recurInterval)) < 60000L) {
            LOG.error("Recurrence must be at least {} ms", (Object)60000L);
            return false;
        }
        return true;
    }

    public static ScheduleConfig from(ScheduleBean bean) {
        return new ScheduleConfig(bean.startTime, bean.recurUnit, bean.recurInterval);
    }

    public static ScheduleConfig oneTimeDelayedStart(Date startTime) {
        return new ScheduleConfig(startTime, null, null);
    }

    public static ScheduleConfig recurringFromNow(TimeUnit recurUnit, long recurInterval) {
        return new ScheduleConfig(new Date(), recurUnit, recurInterval);
    }

    public static ScheduleConfig recurringFromDate(Date startTime, TimeUnit recurUnit, long recurInterval) {
        if (startTime == null) {
            startTime = new Date();
        }
        return new ScheduleConfig(startTime, recurUnit, recurInterval);
    }
}

