/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.Transition;
import org.apache.helix.model.builder.StateTransitionTableBuilder;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public final class TaskSMD
extends StateModelDefinition {
    public TaskSMD() {
        super(TaskSMD.generateConfigForTaskStateModel());
    }

    public static StateModelDefinition build() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder("Task");
        builder.initialState(TaskPartitionState.INIT.name());
        builder.addState(TaskPartitionState.INIT.name(), 0);
        builder.addState(TaskPartitionState.RUNNING.name(), 1);
        builder.addState(TaskPartitionState.STOPPED.name(), 2);
        builder.addState(TaskPartitionState.COMPLETED.name(), 3);
        builder.addState(TaskPartitionState.TIMED_OUT.name(), 4);
        builder.addState(TaskPartitionState.TASK_ERROR.name(), 5);
        builder.addState(TaskPartitionState.TASK_ABORTED.name(), 6);
        builder.addState(TaskPartitionState.DROPPED.name());
        builder.addTransition(TaskPartitionState.INIT.name(), TaskPartitionState.RUNNING.name(), 0);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.STOPPED.name(), 1);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.COMPLETED.name(), 2);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.TIMED_OUT.name(), 3);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.TASK_ERROR.name(), 4);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.TASK_ABORTED.name(), 5);
        builder.addTransition(TaskPartitionState.STOPPED.name(), TaskPartitionState.RUNNING.name(), 6);
        builder.addTransition(TaskPartitionState.INIT.name(), TaskPartitionState.DROPPED.name(), 7);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.DROPPED.name(), 8);
        builder.addTransition(TaskPartitionState.COMPLETED.name(), TaskPartitionState.DROPPED.name(), 9);
        builder.addTransition(TaskPartitionState.STOPPED.name(), TaskPartitionState.DROPPED.name(), 10);
        builder.addTransition(TaskPartitionState.TIMED_OUT.name(), TaskPartitionState.DROPPED.name(), 11);
        builder.addTransition(TaskPartitionState.TASK_ERROR.name(), TaskPartitionState.DROPPED.name(), 12);
        builder.addTransition(TaskPartitionState.TASK_ABORTED.name(), TaskPartitionState.DROPPED.name(), 13);
        builder.addTransition(TaskPartitionState.RUNNING.name(), TaskPartitionState.INIT.name(), 14);
        builder.addTransition(TaskPartitionState.COMPLETED.name(), TaskPartitionState.INIT.name(), 15);
        builder.addTransition(TaskPartitionState.STOPPED.name(), TaskPartitionState.INIT.name(), 16);
        builder.addTransition(TaskPartitionState.TIMED_OUT.name(), TaskPartitionState.INIT.name(), 17);
        builder.addTransition(TaskPartitionState.TASK_ERROR.name(), TaskPartitionState.INIT.name(), 18);
        builder.addTransition(TaskPartitionState.TASK_ABORTED.name(), TaskPartitionState.INIT.name(), 19);
        return builder.build();
    }

    @Deprecated
    public static ZNRecord generateConfigForTaskStateModel() {
        ZNRecord record = new ZNRecord("Task");
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), TaskPartitionState.INIT.name());
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add(TaskPartitionState.INIT.name());
        statePriorityList.add(TaskPartitionState.RUNNING.name());
        statePriorityList.add(TaskPartitionState.STOPPED.name());
        statePriorityList.add(TaskPartitionState.COMPLETED.name());
        statePriorityList.add(TaskPartitionState.TIMED_OUT.name());
        statePriorityList.add(TaskPartitionState.TASK_ERROR.name());
        statePriorityList.add(TaskPartitionState.TASK_ABORTED.name());
        statePriorityList.add(TaskPartitionState.DROPPED.name());
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            String key = state + ".meta";
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        ArrayList<String> states = new ArrayList<String>();
        states.add(TaskPartitionState.INIT.name());
        states.add(TaskPartitionState.RUNNING.name());
        states.add(TaskPartitionState.STOPPED.name());
        states.add(TaskPartitionState.COMPLETED.name());
        states.add(TaskPartitionState.TIMED_OUT.name());
        states.add(TaskPartitionState.TASK_ERROR.name());
        states.add(TaskPartitionState.TASK_ABORTED.name());
        states.add(TaskPartitionState.DROPPED.name());
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.add(new Transition(TaskPartitionState.INIT.name(), TaskPartitionState.RUNNING.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.STOPPED.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.COMPLETED.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.TIMED_OUT.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.TASK_ERROR.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.TASK_ABORTED.name()));
        transitions.add(new Transition(TaskPartitionState.STOPPED.name(), TaskPartitionState.RUNNING.name()));
        transitions.add(new Transition(TaskPartitionState.INIT.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.COMPLETED.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.STOPPED.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.TIMED_OUT.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.TASK_ERROR.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.TASK_ABORTED.name(), TaskPartitionState.DROPPED.name()));
        transitions.add(new Transition(TaskPartitionState.RUNNING.name(), TaskPartitionState.INIT.name()));
        transitions.add(new Transition(TaskPartitionState.COMPLETED.name(), TaskPartitionState.INIT.name()));
        transitions.add(new Transition(TaskPartitionState.STOPPED.name(), TaskPartitionState.INIT.name()));
        transitions.add(new Transition(TaskPartitionState.TIMED_OUT.name(), TaskPartitionState.INIT.name()));
        transitions.add(new Transition(TaskPartitionState.TASK_ERROR.name(), TaskPartitionState.INIT.name()));
        transitions.add(new Transition(TaskPartitionState.TASK_ABORTED.name(), TaskPartitionState.INIT.name()));
        StateTransitionTableBuilder builder = new StateTransitionTableBuilder();
        Map<String, Map<String, String>> next = builder.buildTransitionTable(states, transitions);
        for (String state : statePriorityList) {
            String key = state + ".next";
            record.setMapField(key, next.get(state));
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.INIT.name(), TaskPartitionState.RUNNING.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.STOPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.COMPLETED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.TIMED_OUT.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.TASK_ERROR.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.TASK_ABORTED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.STOPPED.name(), TaskPartitionState.RUNNING.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.INIT.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.COMPLETED.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.STOPPED.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.TIMED_OUT.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.TASK_ERROR.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.TASK_ABORTED.name(), TaskPartitionState.DROPPED.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.RUNNING.name(), TaskPartitionState.INIT.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.COMPLETED.name(), TaskPartitionState.INIT.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.STOPPED.name(), TaskPartitionState.INIT.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.TIMED_OUT.name(), TaskPartitionState.INIT.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.TASK_ERROR.name(), TaskPartitionState.INIT.name()));
        stateTransitionPriorityList.add(String.format("%s-%s", TaskPartitionState.TASK_ABORTED.name(), TaskPartitionState.INIT.name()));
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }
}

