/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.helix.zookeeper.zkclient.IDefaultNameSpace;
import org.apache.helix.zookeeper.zkclient.NetworkUtil;
import org.apache.helix.zookeeper.zkclient.ZkClient;
import org.apache.helix.zookeeper.zkclient.ZkConnection;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.apache.helix.zookeeper.zkclient.serialize.BasicZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.SerializableSerializer;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServer {
    private static Logger LOG = LoggerFactory.getLogger(ZkServer.class);
    public static final int DEFAULT_PORT = 2181;
    public static final int DEFAULT_TICK_TIME = 5000;
    public static final int DEFAULT_MIN_SESSION_TIMEOUT = 10000;
    private String _dataDir;
    private String _logDir;
    private IDefaultNameSpace _defaultNameSpace;
    private ZooKeeperServer _zk;
    private NIOServerCnxnFactory _nioFactory;
    private ZkClient _zkClient;
    private int _port;
    private int _tickTime;
    private int _minSessionTimeout;

    public ZkServer(String dataDir, String logDir, IDefaultNameSpace defaultNameSpace) {
        this(dataDir, logDir, defaultNameSpace, 2181);
    }

    public ZkServer(String dataDir, String logDir, IDefaultNameSpace defaultNameSpace, int port) {
        this(dataDir, logDir, defaultNameSpace, port, 5000);
    }

    public ZkServer(String dataDir, String logDir, IDefaultNameSpace defaultNameSpace, int port, int tickTime) {
        this(dataDir, logDir, defaultNameSpace, port, tickTime, 10000);
    }

    public ZkServer(String dataDir, String logDir, IDefaultNameSpace defaultNameSpace, int port, int tickTime, int minSessionTimeout) {
        this._dataDir = dataDir;
        this._logDir = logDir;
        this._defaultNameSpace = defaultNameSpace;
        this._port = port;
        this._tickTime = tickTime;
        this._minSessionTimeout = minSessionTimeout;
    }

    public int getPort() {
        return this._port;
    }

    @PostConstruct
    public void start() {
        this.startZooKeeperServer();
        this._zkClient = new ZkClient(new ZkConnection("localhost:" + this._port), 10000, -1L, new BasicZkSerializer(new SerializableSerializer()), null, null, null, false);
        this._defaultNameSpace.createDefaultNameSpace(this._zkClient);
    }

    private void startZooKeeperServer() {
        long startTime = System.currentTimeMillis();
        if (!NetworkUtil.isPortFree(this._port)) {
            throw new IllegalStateException("Zookeeper port " + this._port + " was already in use. Running in single machine mode?");
        }
        File dataDir = new File(this._dataDir);
        File dataLogDir = new File(this._logDir);
        dataDir.mkdirs();
        dataLogDir.mkdirs();
        LOG.info(String.format("Starting single zookeeper server on port %d...", this._port));
        LOG.info("data dir: " + dataDir.getAbsolutePath());
        LOG.info("data log dir: " + dataLogDir.getAbsolutePath());
        this.startSingleZkServer(this._tickTime, dataDir, dataLogDir, this._port);
        LOG.info(String.format("Started single zookeeper server on port %d in %d milliseconds", this._port, System.currentTimeMillis() - startTime));
    }

    private void startSingleZkServer(int tickTime, File dataDir, File dataLogDir, int port) {
        try {
            this._zk = new ZooKeeperServer(dataDir, dataLogDir, tickTime);
            this._zk.setMinSessionTimeout(this._minSessionTimeout);
            this._nioFactory = new NIOServerCnxnFactory();
            int maxClientConnections = 0;
            this._nioFactory.configure(new InetSocketAddress(port), maxClientConnections);
            this._nioFactory.startup(this._zk);
        }
        catch (IOException e) {
            throw new ZkException("Unable to start single ZooKeeper server.", e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    @PreDestroy
    public void shutdown() {
        LOG.info("Shutting down ZkServer...");
        try {
            this._zkClient.close();
        }
        catch (ZkException e) {
            LOG.warn("Error on closing zkclient: " + e.getClass().getName());
        }
        if (this._nioFactory != null) {
            this._nioFactory.shutdown();
            try {
                this._nioFactory.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this._nioFactory = null;
        }
        if (this._zk != null) {
            this._zk.shutdown(true);
            this._zk = null;
        }
        LOG.info("Shutting down ZkServer...done");
    }

    public ZkClient getZkClient() {
        return this._zkClient;
    }
}

