/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.metrics;

import javax.management.JMException;
import org.apache.helix.HelixException;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.metrics.MetricCollector;
import org.apache.helix.monitoring.metrics.implementation.BaselineDivergenceGauge;
import org.apache.helix.monitoring.metrics.implementation.RebalanceCounter;
import org.apache.helix.monitoring.metrics.implementation.RebalanceFailureCount;
import org.apache.helix.monitoring.metrics.implementation.RebalanceLatencyGauge;

public class WagedRebalancerMetricCollector
extends MetricCollector {
    private static final String WAGED_REBALANCER_ENTITY_NAME = "WagedRebalancer";

    public WagedRebalancerMetricCollector(String clusterName) {
        super(MonitorDomainNames.Rebalancer.name(), clusterName, WAGED_REBALANCER_ENTITY_NAME);
        this.createMetrics();
        if (clusterName != null) {
            try {
                this.register();
            }
            catch (JMException e) {
                throw new HelixException("Failed to register MBean for the WagedRebalancerMetricCollector.", e);
            }
        }
    }

    public WagedRebalancerMetricCollector() {
        this(null);
    }

    private void createMetrics() {
        RebalanceLatencyGauge globalBaselineCalcLatencyGauge = new RebalanceLatencyGauge(WagedRebalancerMetricNames.GlobalBaselineCalcLatencyGauge.name(), this.getResetIntervalInMs());
        RebalanceLatencyGauge partialRebalanceLatencyGauge = new RebalanceLatencyGauge(WagedRebalancerMetricNames.PartialRebalanceLatencyGauge.name(), this.getResetIntervalInMs());
        RebalanceLatencyGauge stateReadLatencyGauge = new RebalanceLatencyGauge(WagedRebalancerMetricNames.StateReadLatencyGauge.name(), this.getResetIntervalInMs());
        RebalanceLatencyGauge stateWriteLatencyGauge = new RebalanceLatencyGauge(WagedRebalancerMetricNames.StateWriteLatencyGauge.name(), this.getResetIntervalInMs());
        BaselineDivergenceGauge baselineDivergenceGauge = new BaselineDivergenceGauge(WagedRebalancerMetricNames.BaselineDivergenceGauge.name());
        RebalanceFailureCount calcFailureCount = new RebalanceFailureCount(WagedRebalancerMetricNames.RebalanceFailureCounter.name());
        RebalanceCounter globalBaselineCalcCounter = new RebalanceCounter(WagedRebalancerMetricNames.GlobalBaselineCalcCounter.name());
        RebalanceCounter partialRebalanceCounter = new RebalanceCounter(WagedRebalancerMetricNames.PartialRebalanceCounter.name());
        this.addMetric(globalBaselineCalcLatencyGauge);
        this.addMetric(partialRebalanceLatencyGauge);
        this.addMetric(stateReadLatencyGauge);
        this.addMetric(stateWriteLatencyGauge);
        this.addMetric(baselineDivergenceGauge);
        this.addMetric(calcFailureCount);
        this.addMetric(globalBaselineCalcCounter);
        this.addMetric(partialRebalanceCounter);
    }

    public static enum WagedRebalancerMetricNames {
        GlobalBaselineCalcLatencyGauge,
        PartialRebalanceLatencyGauge,
        StateReadLatencyGauge,
        StateWriteLatencyGauge,
        BaselineDivergenceGauge,
        RebalanceFailureCounter,
        GlobalBaselineCalcCounter,
        PartialRebalanceCounter;

    }
}

