/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.ArrayList;
import javax.management.JMException;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class ParticipantMessageMonitor
extends DynamicMBeanProvider {
    private static final String MBEAN_DESCRIPTION = "Helix Participant Message Monitor";
    private final String _domainName;
    public static final String PARTICIPANT_STATUS_KEY = "ParticipantMessageStatus";
    private final String _participantName;
    private SimpleDynamicMetric<Long> _receivedMessages;
    private SimpleDynamicMetric<Long> _discardedMessages;
    private SimpleDynamicMetric<Long> _completedMessages;
    private SimpleDynamicMetric<Long> _failedMessages;
    private SimpleDynamicMetric<Long> _pendingMessages;

    public ParticipantMessageMonitor(String domainName, String participantName) {
        this._domainName = domainName;
        this._participantName = participantName;
        this._receivedMessages = new SimpleDynamicMetric<Long>("ReceivedMessages", 0L);
        this._discardedMessages = new SimpleDynamicMetric<Long>("DiscardedMessages", 0L);
        this._completedMessages = new SimpleDynamicMetric<Long>("CompletedMessages", 0L);
        this._failedMessages = new SimpleDynamicMetric<Long>("FailedMessages", 0L);
        this._pendingMessages = new SimpleDynamicMetric<Long>("PendingMessages", 0L);
    }

    public void incrementReceivedMessages(long count) {
        this.incrementSimpleDynamicMetric(this._receivedMessages, count);
    }

    public void incrementDiscardedMessages(int count) {
        this.incrementSimpleDynamicMetric(this._discardedMessages, count);
    }

    public void incrementCompletedMessages(int count) {
        this.incrementSimpleDynamicMetric(this._completedMessages, count);
    }

    public void incrementFailedMessages(int count) {
        this.incrementSimpleDynamicMetric(this._failedMessages, count);
    }

    public void incrementPendingMessages(int count) {
        this.incrementSimpleDynamicMetric(this._pendingMessages, count);
    }

    public void decrementPendingMessages(int count) {
        this.incrementSimpleDynamicMetric(this._pendingMessages, -1 * count);
    }

    @Override
    public String getSensorName() {
        return PARTICIPANT_STATUS_KEY;
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._receivedMessages);
        attributeList.add(this._discardedMessages);
        attributeList.add(this._completedMessages);
        attributeList.add(this._failedMessages);
        attributeList.add(this._pendingMessages);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, this._domainName, "ParticipantName", this._participantName, "MonitorType", ParticipantMessageMonitor.class.getSimpleName());
        return this;
    }

    public static enum ProcessedMessageState {
        DISCARDED,
        FAILED,
        COMPLETED;

    }
}

