/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.api.client;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.ChildrenSubscribeResult;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.constant.RoutingDataReaderType;
import org.apache.helix.zookeeper.routing.RoutingDataManager;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallbacks;
import org.apache.helix.zookeeper.zkclient.exception.ZkTimeoutException;
import org.apache.helix.zookeeper.zkclient.serialize.BasicZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.SerializableSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public interface RealmAwareZkClient {
    public static final int DEFAULT_OPERATION_TIMEOUT = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT = 30000;

    @Deprecated
    public List<String> subscribeChildChanges(String var1, IZkChildListener var2);

    public ChildrenSubscribeResult subscribeChildChanges(String var1, IZkChildListener var2, boolean var3);

    public void unsubscribeChildChanges(String var1, IZkChildListener var2);

    @Deprecated
    public void subscribeDataChanges(String var1, IZkDataListener var2);

    public boolean subscribeDataChanges(String var1, IZkDataListener var2, boolean var3);

    public void unsubscribeDataChanges(String var1, IZkDataListener var2);

    default public void subscribeStateChanges(IZkStateListener listener) {
        this.subscribeStateChanges(new I0ItecIZkStateListenerImpl(listener));
    }

    default public void unsubscribeStateChanges(IZkStateListener listener) {
        this.unsubscribeStateChanges(new I0ItecIZkStateListenerImpl(listener));
    }

    @Deprecated
    public void subscribeStateChanges(org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener var1);

    @Deprecated
    public void unsubscribeStateChanges(org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener var1);

    public void unsubscribeAll();

    public void createPersistent(String var1);

    public void createPersistent(String var1, boolean var2);

    public void createPersistent(String var1, boolean var2, List<ACL> var3);

    public void createPersistent(String var1, Object var2);

    public void createPersistent(String var1, Object var2, List<ACL> var3);

    public void createPersistentWithTTL(String var1, long var2);

    public void createPersistentWithTTL(String var1, boolean var2, long var3);

    public void createPersistentWithTTL(String var1, boolean var2, List<ACL> var3, long var4);

    public void createPersistentWithTTL(String var1, Object var2, long var3);

    public void createPersistentWithTTL(String var1, Object var2, List<ACL> var3, long var4);

    public String createPersistentSequential(String var1, Object var2);

    public String createPersistentSequential(String var1, Object var2, List<ACL> var3);

    public String createPersistentSequentialWithTTL(String var1, Object var2, long var3);

    public String createPersistentSequentialWithTTL(String var1, Object var2, List<ACL> var3, long var4);

    public void createContainer(String var1);

    public void createContainer(String var1, boolean var2);

    public void createContainer(String var1, boolean var2, List<ACL> var3);

    public void createContainer(String var1, Object var2);

    public void createContainer(String var1, Object var2, List<ACL> var3);

    public void createEphemeral(String var1);

    public void createEphemeral(String var1, String var2);

    public void createEphemeral(String var1, List<ACL> var2);

    public void createEphemeral(String var1, List<ACL> var2, String var3);

    public String create(String var1, Object var2, CreateMode var3);

    public String create(String var1, Object var2, CreateMode var3, long var4);

    public String create(String var1, Object var2, List<ACL> var3, CreateMode var4);

    public String create(String var1, Object var2, List<ACL> var3, CreateMode var4, long var5);

    public void createEphemeral(String var1, Object var2);

    public void createEphemeral(String var1, Object var2, String var3);

    public void createEphemeral(String var1, Object var2, List<ACL> var3);

    public void createEphemeral(String var1, Object var2, List<ACL> var3, String var4);

    public String createEphemeralSequential(String var1, Object var2);

    public String createEphemeralSequential(String var1, Object var2, List<ACL> var3);

    public String createEphemeralSequential(String var1, Object var2, String var3);

    public String createEphemeralSequential(String var1, Object var2, List<ACL> var3, String var4);

    public List<String> getChildren(String var1);

    public int countChildren(String var1);

    public boolean exists(String var1);

    public Stat getStat(String var1);

    public boolean waitUntilExists(String var1, TimeUnit var2, long var3);

    public void deleteRecursively(String var1);

    public boolean delete(String var1);

    public <T> T readData(String var1);

    public <T> T readData(String var1, boolean var2);

    public <T> T readData(String var1, Stat var2);

    public <T> T readData(String var1, Stat var2, boolean var3);

    public <T> T readDataAndStat(String var1, Stat var2, boolean var3);

    public void writeData(String var1, Object var2);

    public <T> void updateDataSerialized(String var1, DataUpdater<T> var2);

    public void writeData(String var1, Object var2, int var3);

    public Stat writeDataReturnStat(String var1, Object var2, int var3);

    public Stat writeDataGetStat(String var1, Object var2, int var3);

    public void asyncCreate(String var1, Object var2, CreateMode var3, ZkAsyncCallbacks.CreateCallbackHandler var4);

    public void asyncCreate(String var1, Object var2, CreateMode var3, long var4, ZkAsyncCallbacks.CreateCallbackHandler var6);

    public void asyncSetData(String var1, Object var2, int var3, ZkAsyncCallbacks.SetDataCallbackHandler var4);

    public void asyncGetData(String var1, ZkAsyncCallbacks.GetDataCallbackHandler var2);

    public void asyncExists(String var1, ZkAsyncCallbacks.ExistsCallbackHandler var2);

    public void asyncDelete(String var1, ZkAsyncCallbacks.DeleteCallbackHandler var2);

    public void watchForData(String var1);

    public List<String> watchForChilds(String var1);

    public long getCreationTime(String var1);

    public List<OpResult> multi(Iterable<Op> var1);

    public boolean waitUntilConnected(long var1, TimeUnit var3);

    default public long waitForEstablishedSession(long timeout, TimeUnit timeUnit) {
        if (!this.waitUntilConnected(timeout, timeUnit)) {
            throw new ZkTimeoutException("Failed to get established session because connecting to ZK server has timed out in " + timeout + " " + (Object)((Object)timeUnit));
        }
        return this.getSessionId();
    }

    public String getServers();

    public long getSessionId();

    public void close();

    public boolean isClosed();

    public byte[] serialize(Object var1, String var2);

    public <T> T deserialize(byte[] var1, String var2);

    public void setZkSerializer(ZkSerializer var1);

    public void setZkSerializer(PathBasedZkSerializer var1);

    public PathBasedZkSerializer getZkSerializer();

    default public RealmAwareZkConnectionConfig getRealmAwareZkConnectionConfig() {
        throw new UnsupportedOperationException("getRealmAwareZkClientConfig() is not supported!");
    }

    default public RealmAwareZkClientConfig getRealmAwareZkClientConfig() {
        throw new UnsupportedOperationException("getRealmAwareZkClientConfig() is not supported!");
    }

    default public void subscribeRoutingDataChanges(IZkChildListener childListener, IZkDataListener dataListener) {
        this.subscribeChildChanges("/METADATA_STORE_ROUTING_DATA", childListener);
        for (String child : this.getChildren("/METADATA_STORE_ROUTING_DATA")) {
            this.subscribeDataChanges("/METADATA_STORE_ROUTING_DATA/" + child, dataListener);
        }
    }

    public static MetadataStoreRoutingData getMetadataStoreRoutingData(RealmAwareZkConnectionConfig connectionConfig) throws InvalidRoutingDataException {
        String routingDataSourceEndpoint = connectionConfig.getRoutingDataSourceEndpoint();
        if (routingDataSourceEndpoint == null || routingDataSourceEndpoint.isEmpty()) {
            return RoutingDataManager.getInstance().getMetadataStoreRoutingData();
        }
        return RoutingDataManager.getInstance().getMetadataStoreRoutingData(RoutingDataReaderType.lookUp(connectionConfig.getRoutingDataSourceType()), routingDataSourceEndpoint);
    }

    public static class RealmAwareZkClientConfig {
        protected long _connectInitTimeout = 60000L;
        protected long _operationRetryTimeout = Integer.MAX_VALUE;
        protected PathBasedZkSerializer _zkSerializer;
        protected String _monitorType;
        protected String _monitorKey;
        protected String _monitorInstanceName = null;
        protected boolean _monitorRootPathOnly = true;

        public RealmAwareZkClientConfig setZkSerializer(PathBasedZkSerializer zkSerializer) {
            this._zkSerializer = zkSerializer;
            return this;
        }

        public RealmAwareZkClientConfig setZkSerializer(ZkSerializer zkSerializer) {
            this._zkSerializer = new BasicZkSerializer(zkSerializer);
            return this;
        }

        public RealmAwareZkClientConfig setMonitorType(String monitorType) {
            this._monitorType = monitorType;
            return this;
        }

        public RealmAwareZkClientConfig setMonitorKey(String monitorKey) {
            this._monitorKey = monitorKey;
            return this;
        }

        public RealmAwareZkClientConfig setMonitorInstanceName(String instanceName) {
            this._monitorInstanceName = instanceName;
            return this;
        }

        public RealmAwareZkClientConfig setMonitorRootPathOnly(Boolean monitorRootPathOnly) {
            this._monitorRootPathOnly = monitorRootPathOnly;
            return this;
        }

        public RealmAwareZkClientConfig setOperationRetryTimeout(Long operationRetryTimeout) {
            this._operationRetryTimeout = operationRetryTimeout;
            return this;
        }

        public RealmAwareZkClientConfig setConnectInitTimeout(long _connectInitTimeout) {
            this._connectInitTimeout = _connectInitTimeout;
            return this;
        }

        public PathBasedZkSerializer getZkSerializer() {
            if (this._zkSerializer == null) {
                this._zkSerializer = new BasicZkSerializer(new SerializableSerializer());
            }
            return this._zkSerializer;
        }

        public long getOperationRetryTimeout() {
            return this._operationRetryTimeout;
        }

        public String getMonitorType() {
            return this._monitorType;
        }

        public String getMonitorKey() {
            return this._monitorKey;
        }

        public String getMonitorInstanceName() {
            return this._monitorInstanceName;
        }

        public boolean isMonitorRootPathOnly() {
            return this._monitorRootPathOnly;
        }

        public long getConnectInitTimeout() {
            return this._connectInitTimeout;
        }

        public HelixZkClient.ZkClientConfig createHelixZkClientConfig() {
            return new HelixZkClient.ZkClientConfig().setZkSerializer(this._zkSerializer).setMonitorType(this._monitorType).setMonitorKey(this._monitorKey).setMonitorInstanceName(this._monitorInstanceName).setMonitorRootPathOnly(this._monitorRootPathOnly).setOperationRetryTimeout(this._operationRetryTimeout).setConnectInitTimeout(this._connectInitTimeout);
        }
    }

    public static class RealmAwareZkConnectionConfig {
        private String _zkRealmShardingKey;
        private String _routingDataSourceType;
        private String _routingDataSourceEndpoint;
        private int _sessionTimeout = 30000;

        private RealmAwareZkConnectionConfig(Builder builder) {
            this._zkRealmShardingKey = builder._zkRealmShardingKey;
            this._routingDataSourceType = builder._routingDataSourceType;
            this._routingDataSourceEndpoint = builder._routingDataSourceEndpoint;
            this._sessionTimeout = builder._sessionTimeout;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RealmAwareZkConnectionConfig)) {
                return false;
            }
            RealmAwareZkConnectionConfig configObj = (RealmAwareZkConnectionConfig)obj;
            return (this._zkRealmShardingKey == null && configObj._zkRealmShardingKey == null || this._zkRealmShardingKey != null && this._zkRealmShardingKey.equals(configObj._zkRealmShardingKey)) && this._sessionTimeout == configObj._sessionTimeout;
        }

        public int hashCode() {
            return this._sessionTimeout * 31 + this._zkRealmShardingKey.hashCode();
        }

        public String toString() {
            return (this._zkRealmShardingKey + "_" + this._sessionTimeout).replaceAll("[\\W]", "_");
        }

        public RealmAwareZkConnectionConfig setSessionTimeout(int sessionTimeout) {
            this._sessionTimeout = sessionTimeout;
            return this;
        }

        public String getZkRealmShardingKey() {
            return this._zkRealmShardingKey;
        }

        public int getSessionTimeout() {
            return this._sessionTimeout;
        }

        public String getRoutingDataSourceType() {
            return this._routingDataSourceType;
        }

        public String getRoutingDataSourceEndpoint() {
            return this._routingDataSourceEndpoint;
        }

        public static class Builder {
            private RealmMode _realmMode;
            private String _zkRealmShardingKey;
            private String _routingDataSourceType;
            private String _routingDataSourceEndpoint;
            private int _sessionTimeout = 30000;

            public Builder setRealmMode(RealmMode mode) {
                this._realmMode = mode;
                return this;
            }

            public Builder setZkRealmShardingKey(String shardingKey) {
                this._zkRealmShardingKey = shardingKey;
                return this;
            }

            public Builder setRoutingDataSourceType(String routingDataSourceType) {
                this._routingDataSourceType = routingDataSourceType;
                return this;
            }

            public Builder setRoutingDataSourceEndpoint(String routingDataSourceEndpoint) {
                this._routingDataSourceEndpoint = routingDataSourceEndpoint;
                return this;
            }

            public Builder setSessionTimeout(int sessionTimeout) {
                this._sessionTimeout = sessionTimeout;
                return this;
            }

            public RealmAwareZkConnectionConfig build() {
                this.validate();
                return new RealmAwareZkConnectionConfig(this);
            }

            private void validate() {
                boolean isShardingKeySet;
                boolean bl = isShardingKeySet = this._zkRealmShardingKey != null && !this._zkRealmShardingKey.isEmpty();
                if (this._realmMode == RealmMode.MULTI_REALM && isShardingKeySet) {
                    throw new IllegalArgumentException("RealmAwareZkConnectionConfig.Builder: ZK sharding key cannot be set on multi-realm mode! Sharding key: " + this._zkRealmShardingKey);
                }
                if (this._realmMode == RealmMode.SINGLE_REALM && !isShardingKeySet) {
                    throw new IllegalArgumentException("RealmAwareZkConnectionConfig.Builder: ZK sharding key must be set on single-realm mode!");
                }
                if (this._routingDataSourceEndpoint == null && this._routingDataSourceType != null || this._routingDataSourceEndpoint != null && this._routingDataSourceType == null) {
                    throw new IllegalArgumentException("RealmAwareZkConnectionConfig.Builder: routing data source type and endpoint are not configured properly! Type: " + this._routingDataSourceType + " Endpoint: " + this._routingDataSourceEndpoint);
                }
            }
        }
    }

    public static class I0ItecIZkStateListenerImpl
    implements org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener {
        private IZkStateListener _listener;

        I0ItecIZkStateListenerImpl(IZkStateListener listener) {
            this._listener = listener;
        }

        @Override
        public void handleStateChanged(Watcher.Event.KeeperState keeperState) throws Exception {
            this._listener.handleStateChanged(keeperState);
        }

        @Override
        public void handleNewSession() throws Exception {
            this._listener.handleNewSession(null);
        }

        @Override
        public void handleSessionEstablishmentError(Throwable error) throws Exception {
            this._listener.handleSessionEstablishmentError(error);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof I0ItecIZkStateListenerImpl)) {
                return false;
            }
            if (this._listener == null) {
                return false;
            }
            I0ItecIZkStateListenerImpl defaultListener = (I0ItecIZkStateListenerImpl)obj;
            return this._listener.equals(defaultListener._listener);
        }

        public int hashCode() {
            return this._listener.hashCode();
        }
    }

    public static enum RealmMode {
        SINGLE_REALM,
        MULTI_REALM;

    }
}

