/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final Logger logger = LoggerFactory.getLogger((String)Pipeline.class.getName());
    private final String _pipelineType;
    List<Stage> _stages = new ArrayList<Stage>();

    public Pipeline() {
        this("");
    }

    public Pipeline(String pipelineType) {
        this._pipelineType = pipelineType;
    }

    public void addStage(Stage stage) {
        this._stages.add(stage);
        StageContext context = null;
        stage.init(context);
    }

    public String getPipelineType() {
        return this._pipelineType;
    }

    public void handle(ClusterEvent event) throws Exception {
        if (this._stages == null) {
            return;
        }
        for (Stage stage : this._stages) {
            long startTime = System.currentTimeMillis();
            stage.preProcess();
            stage.process(event);
            stage.postProcess();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            logger.info(String.format("END %s for %s pipeline for cluster %s. took: %d ms for event %s", stage.getStageName(), this._pipelineType, event.getClusterName(), duration, event.getEventId()));
            ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
            if (clusterStatusMonitor == null) continue;
            clusterStatusMonitor.updateClusterEventDuration(stage.getStageName(), duration);
        }
    }

    public void finish() {
    }

    public List<Stage> getStages() {
        return this._stages;
    }

    public static enum Type {
        DEFAULT,
        TASK;

    }
}

