/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.List;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.manager.zk.DefaultControllerMessageHandlerFactory;
import org.apache.helix.manager.zk.DefaultParticipantErrorMessageHandlerFactory;
import org.apache.helix.manager.zk.DefaultSchedulerMessageHandlerFactory;
import org.apache.helix.messaging.DefaultMessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerManagerHelper {
    private static Logger LOG = LoggerFactory.getLogger(ControllerManagerHelper.class);
    final HelixManager _manager;
    final DefaultMessagingService _messagingService;
    final List<HelixTimerTask> _controllerTimerTasks;

    public ControllerManagerHelper(HelixManager manager, List<HelixTimerTask> controllerTimerTasks) {
        this._manager = manager;
        this._messagingService = (DefaultMessagingService)manager.getMessagingService();
        this._controllerTimerTasks = controllerTimerTasks;
    }

    public void addListenersToController(GenericHelixController controller) {
        try {
            this._manager.addControllerMessageListener(this._messagingService.getExecutor());
            DefaultControllerMessageHandlerFactory defaultControllerMsgHandlerFactory = new DefaultControllerMessageHandlerFactory();
            for (String string : defaultControllerMsgHandlerFactory.getMessageTypes()) {
                this._messagingService.getExecutor().registerMessageHandlerFactory(string, defaultControllerMsgHandlerFactory);
            }
            DefaultSchedulerMessageHandlerFactory defaultSchedulerMsgHandlerFactory = new DefaultSchedulerMessageHandlerFactory(this._manager);
            for (String type : defaultSchedulerMsgHandlerFactory.getMessageTypes()) {
                this._messagingService.getExecutor().registerMessageHandlerFactory(type, defaultSchedulerMsgHandlerFactory);
            }
            DefaultParticipantErrorMessageHandlerFactory defaultParticipantErrorMessageHandlerFactory = new DefaultParticipantErrorMessageHandlerFactory(this._manager);
            for (String type : defaultParticipantErrorMessageHandlerFactory.getMessageTypes()) {
                this._messagingService.getExecutor().registerMessageHandlerFactory(type, defaultParticipantErrorMessageHandlerFactory);
            }
            this._manager.addControllerListener(controller);
            this._manager.addInstanceConfigChangeListener(controller);
            this._manager.addResourceConfigChangeListener(controller);
            this._manager.addClusterfigChangeListener(controller);
            this._manager.addLiveInstanceChangeListener(controller);
            this._manager.addIdealStateChangeListener(controller);
        }
        catch (ZkInterruptedException e) {
            LOG.warn("zk connection is interrupted during HelixManagerMain.addListenersToController(). " + (Object)((Object)e));
        }
        catch (Exception e) {
            LOG.error("Error when creating HelixManagerContollerMonitor", (Throwable)e);
        }
    }

    public void removeListenersFromController(GenericHelixController controller) {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(this._manager.getClusterName());
        this._manager.removeListener(keyBuilder.idealStates(), controller);
        this._manager.removeListener(keyBuilder.liveInstances(), controller);
        this._manager.removeListener(keyBuilder.clusterConfig(), controller);
        this._manager.removeListener(keyBuilder.resourceConfigs(), controller);
        this._manager.removeListener(keyBuilder.instanceConfigs(), controller);
        this._manager.removeListener(keyBuilder.controller(), controller);
        this._manager.removeListener(keyBuilder.controllerMessages(), this._messagingService.getExecutor());
    }

    public void startControllerTimerTasks() {
        for (HelixTimerTask task : this._controllerTimerTasks) {
            task.start();
        }
    }

    public void stopControllerTimerTasks() {
        for (HelixTimerTask task : this._controllerTimerTasks) {
            task.stop();
        }
    }
}

