/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractKotlinSerializationHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StreamUtils;

public abstract class KotlinSerializationBinaryHttpMessageConverter<T extends BinaryFormat>
extends AbstractKotlinSerializationHttpMessageConverter<T> {
    protected KotlinSerializationBinaryHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(format, supportedMediaTypes);
    }

    @Override
    protected Object readInternal(KSerializer<Object> serializer, T format, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        byte[] bytes = StreamUtils.copyToByteArray(inputMessage.getBody());
        try {
            return format.decodeFromByteArray(serializer, bytes);
        }
        catch (SerializationException ex) {
            throw new HttpMessageNotReadableException("Could not read " + String.valueOf(format) + ": " + ex.getMessage(), ex, inputMessage);
        }
    }

    @Override
    protected void writeInternal(Object object, KSerializer<Object> serializer, T format, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            byte[] bytes = format.encodeToByteArray(serializer, object);
            outputMessage.getBody().write(bytes);
            outputMessage.getBody().flush();
        }
        catch (SerializationException ex) {
            throw new HttpMessageNotWritableException("Could not write " + String.valueOf(format) + ": " + ex.getMessage(), ex);
        }
    }
}

