/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisUrl;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.util.ClassUtils;

abstract class RedisConnectionConfiguration {
    private static final boolean COMMONS_POOL2_AVAILABLE = ClassUtils.isPresent("org.apache.commons.pool2.ObjectPool", RedisConnectionConfiguration.class.getClassLoader());
    private final RedisProperties properties;
    private final RedisStandaloneConfiguration standaloneConfiguration;
    private final RedisSentinelConfiguration sentinelConfiguration;
    private final RedisClusterConfiguration clusterConfiguration;
    private final RedisConnectionDetails connectionDetails;
    protected final Mode mode;

    protected RedisConnectionConfiguration(RedisProperties properties, RedisConnectionDetails connectionDetails, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigurationProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigurationProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigurationProvider) {
        this.properties = properties;
        this.standaloneConfiguration = standaloneConfigurationProvider.getIfAvailable();
        this.sentinelConfiguration = sentinelConfigurationProvider.getIfAvailable();
        this.clusterConfiguration = clusterConfigurationProvider.getIfAvailable();
        this.connectionDetails = connectionDetails;
        this.mode = this.determineMode();
    }

    protected final RedisStandaloneConfiguration getStandaloneConfig() {
        if (this.standaloneConfiguration != null) {
            return this.standaloneConfiguration;
        }
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.connectionDetails.getStandalone().getHost());
        config.setPort(this.connectionDetails.getStandalone().getPort());
        config.setUsername(this.connectionDetails.getUsername());
        config.setPassword(RedisPassword.of((String)this.connectionDetails.getPassword()));
        config.setDatabase(this.connectionDetails.getStandalone().getDatabase());
        return config;
    }

    protected final RedisSentinelConfiguration getSentinelConfig() {
        if (this.sentinelConfiguration != null) {
            return this.sentinelConfiguration;
        }
        if (this.connectionDetails.getSentinel() != null) {
            RedisSentinelConfiguration config = new RedisSentinelConfiguration();
            config.master(this.connectionDetails.getSentinel().getMaster());
            config.setSentinels(this.createSentinels(this.connectionDetails.getSentinel()));
            config.setUsername(this.connectionDetails.getUsername());
            String password = this.connectionDetails.getPassword();
            if (password != null) {
                config.setPassword(RedisPassword.of((String)password));
            }
            config.setSentinelUsername(this.connectionDetails.getSentinel().getUsername());
            String sentinelPassword = this.connectionDetails.getSentinel().getPassword();
            if (sentinelPassword != null) {
                config.setSentinelPassword(RedisPassword.of((String)sentinelPassword));
            }
            config.setDatabase(this.connectionDetails.getSentinel().getDatabase());
            return config;
        }
        return null;
    }

    protected final RedisClusterConfiguration getClusterConfiguration() {
        if (this.clusterConfiguration != null) {
            return this.clusterConfiguration;
        }
        RedisProperties.Cluster clusterProperties = this.properties.getCluster();
        if (this.connectionDetails.getCluster() != null) {
            RedisClusterConfiguration config = new RedisClusterConfiguration();
            config.setClusterNodes(this.getNodes(this.connectionDetails.getCluster()));
            if (clusterProperties != null && clusterProperties.getMaxRedirects() != null) {
                config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
            }
            config.setUsername(this.connectionDetails.getUsername());
            String password = this.connectionDetails.getPassword();
            if (password != null) {
                config.setPassword(RedisPassword.of((String)password));
            }
            return config;
        }
        return null;
    }

    private List<RedisNode> getNodes(RedisConnectionDetails.Cluster cluster) {
        return cluster.getNodes().stream().map(this::asRedisNode).toList();
    }

    private RedisNode asRedisNode(RedisConnectionDetails.Node node) {
        return new RedisNode(node.host(), node.port());
    }

    protected final RedisProperties getProperties() {
        return this.properties;
    }

    protected SslBundle getSslBundle() {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.STANDALONE -> {
                if (this.connectionDetails.getStandalone() != null) {
                    yield this.connectionDetails.getStandalone().getSslBundle();
                }
                yield null;
            }
            case Mode.CLUSTER -> {
                if (this.connectionDetails.getCluster() != null) {
                    yield this.connectionDetails.getCluster().getSslBundle();
                }
                yield null;
            }
            case Mode.SENTINEL -> this.connectionDetails.getSentinel() != null ? this.connectionDetails.getSentinel().getSslBundle() : null;
        };
    }

    protected final boolean isSslEnabled() {
        return this.getProperties().getSsl().isEnabled();
    }

    protected final boolean urlUsesSsl() {
        return RedisUrl.of(this.properties.getUrl()).useSsl();
    }

    protected boolean isPoolEnabled(RedisProperties.Pool pool) {
        Boolean enabled = pool.getEnabled();
        return enabled != null ? enabled : COMMONS_POOL2_AVAILABLE;
    }

    private List<RedisNode> createSentinels(RedisConnectionDetails.Sentinel sentinel) {
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
        for (RedisConnectionDetails.Node node : sentinel.getNodes()) {
            nodes.add(this.asRedisNode(node));
        }
        return nodes;
    }

    protected final RedisConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    private Mode determineMode() {
        if (this.getSentinelConfig() != null) {
            return Mode.SENTINEL;
        }
        if (this.getClusterConfiguration() != null) {
            return Mode.CLUSTER;
        }
        return Mode.STANDALONE;
    }

    static enum Mode {
        STANDALONE,
        CLUSTER,
        SENTINEL;

    }
}

