/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.pages;

import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.buffer.GrailsRoutablePrintWriter;
import org.grails.buffer.StreamCharBuffer;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.EncodedAppenderFactory;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncoderAware;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.BoundedCharsAsEncodedBytesCounter;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

public class GSPResponseWriter
extends GrailsRoutablePrintWriter
implements EncoderAware,
EncodedAppenderFactory {
    protected static final Log LOG = LogFactory.getLog(GSPResponseWriter.class);
    private ServletResponse response;
    private BoundedCharsAsEncodedBytesCounter bytesCounter;
    public static final boolean CONTENT_LENGTH_COUNTING_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableContentLength");
    public static final boolean BUFFERING_ENABLED = Boolean.valueOf(System.getProperty("GSPResponseWriter.enableBuffering", "true"));
    public static final boolean AUTOFLUSH_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableAutoFlush");
    private static final int BUFFER_SIZE = Integer.getInteger("GSPResponseWriter.bufferSize", 8042);
    private Encoder encoder;
    private StreamCharBuffer buffer;
    private static ObjectInstantiator<GSPResponseWriter> instantiator = null;

    public static GSPResponseWriter getInstance(ServletResponse response) {
        return GSPResponseWriter.getInstance(response, BUFFER_SIZE);
    }

    private static GSPResponseWriter getInstance(final ServletResponse response, final int max) {
        final BoundedCharsAsEncodedBytesCounter bytesCounter = new BoundedCharsAsEncodedBytesCounter();
        StreamCharBuffer streamBuffer = new StreamCharBuffer(max, 0, max);
        streamBuffer.setChunkMinSize(max / 2);
        streamBuffer.setNotifyParentBuffersEnabled(false);
        final StreamCharBuffer.LazyInitializingWriter lazyResponseWriter = () -> ((ServletResponse)response).getWriter();
        if (!(response instanceof StreamCharBuffer.LazyInitializingWriter)) {
            streamBuffer.connectTo(new StreamCharBuffer.LazyInitializingMultipleWriter(){

                @Override
                public Writer getWriter() {
                    return null;
                }

                @Override
                public StreamCharBuffer.LazyInitializingWriter[] initializeMultiple(StreamCharBuffer buffer, boolean autoFlush) {
                    StreamCharBuffer.LazyInitializingWriter[] lazyWriters = CONTENT_LENGTH_COUNTING_ENABLED ? new StreamCharBuffer.LazyInitializingWriter[]{() -> {
                        bytesCounter.setCapacity(max * 2);
                        bytesCounter.setEncoding(response.getCharacterEncoding());
                        return bytesCounter.getCountingWriter();
                    }, lazyResponseWriter} : new StreamCharBuffer.LazyInitializingWriter[]{lazyResponseWriter};
                    return lazyWriters;
                }
            }, AUTOFLUSH_ENABLED);
        } else {
            streamBuffer.connectTo(lazyResponseWriter);
        }
        if (instantiator != null) {
            GSPResponseWriter instance = instantiator.newInstance();
            instance.initialize(streamBuffer, response, bytesCounter);
            return instance;
        }
        return new GSPResponseWriter(streamBuffer, response, bytesCounter);
    }

    private static GSPResponseWriter getInstance(Writer target, int max) {
        if (BUFFERING_ENABLED && !(target instanceof GrailsRoutablePrintWriter) && !(target instanceof StreamCharBuffer.StreamCharBufferWriter)) {
            StreamCharBuffer streamBuffer = new StreamCharBuffer(max, 0, max);
            streamBuffer.connectTo(target, false);
            target = streamBuffer.getWriter();
        }
        if (instantiator == null) {
            return new GSPResponseWriter(target);
        }
        GSPResponseWriter instance = instantiator.newInstance();
        instance.initialize(target);
        return instance;
    }

    private GSPResponseWriter(StreamCharBuffer buffer, ServletResponse response, BoundedCharsAsEncodedBytesCounter bytesCounter) {
        super((GrailsRoutablePrintWriter.DestinationFactory)null);
        this.initialize(buffer, response, bytesCounter);
    }

    void initialize(StreamCharBuffer buffer, ServletResponse response, BoundedCharsAsEncodedBytesCounter bytesCounter) {
        GrailsRoutablePrintWriter.DestinationFactory lazyTargetFactory = () -> {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            Encoder encoder = this.encoder = webRequest != null ? webRequest.lookupFilteringEncoder() : null;
            if (this.encoder != null) {
                return buffer.getWriterForEncoder(this.encoder, webRequest.getEncodingStateRegistry());
            }
            return buffer.getWriter();
        };
        this.updateDestination(lazyTargetFactory);
        this.response = response;
        this.bytesCounter = bytesCounter;
        this.setBlockClose(true);
        this.setBlockFlush(false);
    }

    private GSPResponseWriter(Writer activeWriter) {
        super((GrailsRoutablePrintWriter.DestinationFactory)null);
        this.initialize(activeWriter);
    }

    void initialize(Writer activeWriter) {
        this.updateDestination(() -> activeWriter);
        this.setBlockClose(true);
        this.setBlockFlush(false);
    }

    @Override
    public void close() {
        GrailsWebRequest webRequest;
        this.flush();
        if (this.canFlushContentLengthAwareResponse()) {
            int size = this.bytesCounter.size();
            if (size > 0) {
                this.response.setContentLength(size);
            }
            this.flushResponse();
        } else if (!this.isTrouble() && (webRequest = GrailsWebRequest.lookup()) != null && webRequest.getCurrentRequest().getAttribute("__sitemesh__page") != null) {
            this.flushResponse();
        }
    }

    private boolean canFlushContentLengthAwareResponse() {
        return CONTENT_LENGTH_COUNTING_ENABLED && this.isDestinationActivated() && this.bytesCounter != null && this.bytesCounter.isWriterReferenced() && this.response != null && !this.response.isCommitted() && !this.isTrouble();
    }

    private void flushResponse() {
        try {
            if (this.isDestinationActivated()) {
                this.response.getWriter().flush();
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public boolean isAllowUnwrappingOut() {
        return false;
    }

    @Override
    public Writer unwrap() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EncodedAppender getEncodedAppender() {
        if (this.buffer != null) {
            return ((EncodedAppenderFactory)((Object)this.buffer.getWriter())).getEncodedAppender();
        }
        this.activateDestination();
        try (Writer target = this.getTarget().unwrap();){
            if (target == this) return null;
            if (!(target instanceof EncodedAppenderFactory)) return null;
            EncodedAppender encodedAppender = ((EncodedAppenderFactory)((Object)target)).getEncodedAppender();
            return encodedAppender;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    static {
        try {
            instantiator = new ObjenesisStd(false).getInstantiatorOf(GSPResponseWriter.class);
        }
        catch (Exception e) {
            LOG.debug("Couldn't get direct performance optimized instantiator for GSPResponseWriter. Using default instantiation.", e);
        }
    }
}

