/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ASTTransformationVisitor;
import org.grails.cli.compiler.AstUtils;
import org.grails.cli.compiler.CompilerAutoConfiguration;
import org.grails.cli.compiler.DependencyAutoConfigurationTransformation;
import org.grails.cli.compiler.DependencyManagementBomTransformation;
import org.grails.cli.compiler.ExtendedGroovyClassLoader;
import org.grails.cli.compiler.GroovyBeansTransformation;
import org.grails.cli.compiler.GroovyCompilerConfiguration;
import org.grails.cli.compiler.ResolveDependencyCoordinatesTransformation;
import org.grails.cli.compiler.SmartImportCustomizer;
import org.grails.cli.compiler.SpringBootAstTransformation;
import org.grails.cli.compiler.dependencies.SpringBootDependenciesDependencyManagement;
import org.grails.cli.compiler.grape.DependencyResolutionContext;
import org.grails.cli.compiler.grape.GrapeEngineInstaller;
import org.grails.cli.compiler.grape.MavenResolverGrapeEngine;
import org.grails.cli.compiler.grape.MavenResolverGrapeEngineFactory;
import org.grails.cli.util.ResourceUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;

public class GroovyCompiler {
    private final GroovyCompilerConfiguration configuration;
    private final ExtendedGroovyClassLoader loader;
    private final Iterable<CompilerAutoConfiguration> compilerAutoConfigurations;
    private final List<ASTTransformation> transformations;

    public GroovyCompiler(GroovyCompilerConfiguration configuration) {
        this.configuration = configuration;
        this.loader = this.createLoader(configuration);
        DependencyResolutionContext resolutionContext = new DependencyResolutionContext();
        resolutionContext.addDependencyManagement(new SpringBootDependenciesDependencyManagement());
        MavenResolverGrapeEngine grapeEngine = MavenResolverGrapeEngineFactory.create(this.loader, configuration.getRepositoryConfiguration(), resolutionContext, configuration.isQuiet());
        GrapeEngineInstaller.install(grapeEngine);
        this.loader.getConfiguration().addCompilationCustomizers(new CompilerAutoConfigureCustomizer());
        this.compilerAutoConfigurations = configuration.isAutoconfigure() ? ServiceLoader.load(CompilerAutoConfiguration.class) : Collections.emptySet();
        this.transformations = new ArrayList<ASTTransformation>();
        this.transformations.add(new DependencyManagementBomTransformation(resolutionContext));
        this.transformations.add(new DependencyAutoConfigurationTransformation(this.loader, resolutionContext, this.compilerAutoConfigurations));
        this.transformations.add(new GroovyBeansTransformation());
        if (this.configuration.isGuessDependencies()) {
            this.transformations.add(new ResolveDependencyCoordinatesTransformation(resolutionContext));
        }
        for (ASTTransformation aSTTransformation : ServiceLoader.load(SpringBootAstTransformation.class)) {
            this.transformations.add(aSTTransformation);
        }
        this.transformations.sort(AnnotationAwareOrderComparator.INSTANCE);
    }

    public List<ASTTransformation> getAstTransformations() {
        return this.transformations;
    }

    public ExtendedGroovyClassLoader getLoader() {
        return this.loader;
    }

    private ExtendedGroovyClassLoader createLoader(GroovyCompilerConfiguration configuration) {
        ExtendedGroovyClassLoader loader = new ExtendedGroovyClassLoader(configuration.getScope());
        for (URL url : this.getExistingUrls()) {
            loader.addURL(url);
        }
        for (String classpath : configuration.getClasspath()) {
            loader.addClasspath(classpath);
        }
        return loader;
    }

    private URL[] getExistingUrls() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl instanceof ExtendedGroovyClassLoader) {
            return ((ExtendedGroovyClassLoader)tccl).getURLs();
        }
        return new URL[0];
    }

    public void addCompilationCustomizers(CompilationCustomizer ... customizers) {
        this.loader.getConfiguration().addCompilationCustomizers(customizers);
    }

    public Class<?>[] compile(String ... sources) throws CompilationFailedException, IOException {
        this.loader.clearCache();
        ArrayList classes = new ArrayList();
        CompilerConfiguration configuration = this.loader.getConfiguration();
        CompilationUnit compilationUnit = new CompilationUnit(configuration, null, this.loader);
        GroovyClassLoader.ClassCollector collector = this.loader.createCollector(compilationUnit, null);
        compilationUnit.setClassgenCallback(collector);
        for (String string : sources) {
            List<String> paths = ResourceUtils.getUrls(string, this.loader);
            for (String path : paths) {
                compilationUnit.addSource(new URL(path));
            }
        }
        this.addAstTransformations(compilationUnit);
        compilationUnit.compile(7);
        for (Object loadedClass : collector.getLoadedClasses()) {
            classes.add((Class)loadedClass);
        }
        ClassNode mainClassNode = MainClass.get(compilationUnit);
        Class mainClass = null;
        for (Class clazz : classes) {
            if (!mainClassNode.getName().equals(clazz.getName())) continue;
            mainClass = clazz;
        }
        if (mainClass != null) {
            classes.remove(mainClass);
            classes.add(0, mainClass);
        }
        return ClassUtils.toClassArray(classes);
    }

    private void addAstTransformations(CompilationUnit compilationUnit) {
        Deque[] phaseOperations = this.getPhaseOperations(compilationUnit);
        this.processConversionOperations((LinkedList)phaseOperations[3]);
    }

    private Deque[] getPhaseOperations(CompilationUnit compilationUnit) {
        try {
            Field field = CompilationUnit.class.getDeclaredField("phaseOperations");
            field.setAccessible(true);
            return (Deque[])field.get(compilationUnit);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Phase operations not available from compilation unit");
        }
    }

    private void processConversionOperations(LinkedList conversionOperations) {
        int index2 = this.getIndexOfASTTransformationVisitor(conversionOperations);
        conversionOperations.add(index2, new CompilationUnit.ISourceUnitOperation(){

            @Override
            public void call(SourceUnit source) throws CompilationFailedException {
                ASTNode[] nodes = new ASTNode[]{source.getAST()};
                for (ASTTransformation transformation : GroovyCompiler.this.transformations) {
                    transformation.visit(nodes, source);
                }
            }
        });
    }

    private int getIndexOfASTTransformationVisitor(List<?> conversionOperations) {
        for (int index2 = 0; index2 < conversionOperations.size(); ++index2) {
            if (!conversionOperations.get(index2).getClass().getName().startsWith(ASTTransformationVisitor.class.getName())) continue;
            return index2;
        }
        return conversionOperations.size();
    }

    private class CompilerAutoConfigureCustomizer
    extends CompilationCustomizer {
        CompilerAutoConfigureCustomizer() {
            super(CompilePhase.CONVERSION);
        }

        @Override
        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            SmartImportCustomizer importCustomizer = new SmartImportCustomizer(source);
            List<ClassNode> classNodes = source.getAST().getClasses();
            ClassNode mainClassNode = MainClass.get(classNodes);
            for (CompilerAutoConfiguration autoConfiguration : GroovyCompiler.this.compilerAutoConfigurations) {
                if (!classNodes.stream().anyMatch(autoConfiguration::matches)) continue;
                if (GroovyCompiler.this.configuration.isGuessImports()) {
                    autoConfiguration.applyImports(importCustomizer);
                    importCustomizer.call(source, context, classNode);
                }
                if (classNode.equals(mainClassNode)) {
                    autoConfiguration.applyToMainClass(GroovyCompiler.this.loader, GroovyCompiler.this.configuration, context, source, classNode);
                }
                autoConfiguration.apply(GroovyCompiler.this.loader, GroovyCompiler.this.configuration, context, source, classNode);
            }
            importCustomizer.call(source, context, classNode);
        }
    }

    private static class MainClass {
        private MainClass() {
        }

        static ClassNode get(CompilationUnit source) {
            return MainClass.get(source.getAST().getClasses());
        }

        static ClassNode get(List<ClassNode> classes) {
            for (ClassNode node : classes) {
                if (AstUtils.hasAtLeastOneAnnotation(node, "Enable*AutoConfiguration")) {
                    return null;
                }
                if (!AstUtils.hasAtLeastOneAnnotation(node, "*Controller", "Configuration", "Component", "*Service", "Repository", "Enable*")) continue;
                return node;
            }
            return classes.isEmpty() ? null : classes.get(0);
        }
    }
}

