/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.http.uri.UriMatcher;
import io.micronaut.http.uri.UriTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UriMatchTemplate
extends UriTemplate
implements UriMatcher {
    protected static final String VARIABLE_MATCH_PATTERN = "([^\\/\\?#&;\\+]";
    protected StringBuilder pattern;
    protected List<UriMatchVariable> variables;
    private final Pattern matchPattern;
    private final boolean isRoot;
    private final boolean exactMatch;
    private Optional<UriMatchInfo> rootMatchInfo;
    private Optional<UriMatchInfo> exactMatchInfo;

    public UriMatchTemplate(CharSequence templateString) {
        this(templateString, new Object[0]);
    }

    protected UriMatchTemplate(CharSequence templateString, Object ... parserArguments) {
        super(templateString, parserArguments);
        if (this.variables.isEmpty() && Pattern.quote(templateString.toString()).equals(this.pattern.toString())) {
            this.matchPattern = null;
            this.exactMatch = true;
        } else {
            this.matchPattern = Pattern.compile(this.pattern.toString());
            this.exactMatch = false;
        }
        this.isRoot = this.isRoot();
        this.pattern = null;
    }

    protected UriMatchTemplate(CharSequence templateString, List<UriTemplate.PathSegment> segments, Pattern matchPattern, List<UriMatchVariable> variables) {
        super(templateString.toString(), segments);
        this.variables = variables;
        this.isRoot = this.isRoot();
        if (variables.isEmpty() && matchPattern.matcher(templateString).matches()) {
            this.matchPattern = null;
            this.exactMatch = true;
        } else {
            this.matchPattern = matchPattern;
            this.exactMatch = false;
        }
    }

    protected UriMatchTemplate newUriMatchTemplate(CharSequence uriTemplate, List<UriTemplate.PathSegment> newSegments, Pattern newPattern, List<UriMatchVariable> variables) {
        return new UriMatchTemplate(uriTemplate, newSegments, newPattern, variables);
    }

    public List<String> getVariableNames() {
        return this.variables.stream().map(UriMatchVariable::getName).collect(Collectors.toList());
    }

    public List<UriMatchVariable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public String toPathString() {
        return this.toString(pathSegment -> {
            UriMatchVariable uriMatchVariable;
            Optional<UriMatchVariable> umv;
            Optional<String> var = pathSegment.getVariable();
            return !var.isPresent() || !(umv = this.variables.stream().filter(v -> v.getName().equals(var.get())).findFirst()).isPresent() || !(uriMatchVariable = umv.get()).isQuery();
        });
    }

    public Optional<UriMatchInfo> match(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' cannot be null");
        }
        int length = uri.length();
        if (length > 1 && uri.charAt(length - 1) == '/') {
            uri = uri.substring(0, length - 1);
        }
        if (this.isRoot && (length == 0 || length == 1 && uri.charAt(0) == '/')) {
            if (this.rootMatchInfo == null) {
                this.rootMatchInfo = Optional.of(new DefaultUriMatchInfo(uri, Collections.emptyMap(), this.variables));
            }
            return this.rootMatchInfo;
        }
        int parameterIndex = uri.indexOf(63);
        if (parameterIndex > -1) {
            uri = uri.substring(0, parameterIndex);
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (this.exactMatch) {
            if (uri.equals(this.templateString)) {
                if (this.exactMatchInfo == null) {
                    this.exactMatchInfo = Optional.of(new DefaultUriMatchInfo(uri, Collections.emptyMap(), this.variables));
                }
                return this.exactMatchInfo;
            }
            return Optional.empty();
        }
        Matcher matcher = this.matchPattern.matcher(uri);
        if (matcher.matches()) {
            int index2;
            if (this.variables.isEmpty()) {
                return Optional.of(new DefaultUriMatchInfo(uri, Collections.emptyMap(), this.variables));
            }
            int count = matcher.groupCount();
            LinkedHashMap<String, Object> variableMap = new LinkedHashMap<String, Object>(count);
            for (int j = 0; j < this.variables.size() && (index2 = j * 2 + 2) <= count; ++j) {
                UriMatchVariable variable = this.variables.get(j);
                String value = matcher.group(index2);
                variableMap.put(variable.getName(), value);
            }
            return Optional.of(new DefaultUriMatchInfo(uri, variableMap, this.variables));
        }
        return Optional.empty();
    }

    @Override
    public UriMatchTemplate nest(CharSequence uriTemplate) {
        return (UriMatchTemplate)super.nest(uriTemplate);
    }

    public static UriMatchTemplate of(String uri) {
        return new UriMatchTemplate(uri);
    }

    @Override
    protected UriTemplate newUriTemplate(CharSequence uriTemplate, List<UriTemplate.PathSegment> newSegments) {
        Pattern newPattern = Pattern.compile(this.exactMatch ? Pattern.quote(this.templateString) + this.pattern.toString() : this.matchPattern.pattern() + this.pattern.toString());
        this.pattern = null;
        return this.newUriMatchTemplate(this.normalizeNested(this.toString(), uriTemplate), newSegments, newPattern, new ArrayList<UriMatchVariable>(this.variables));
    }

    @Override
    protected UriTemplate.UriTemplateParser createParser(String templateString, Object ... parserArguments) {
        if (Objects.isNull(this.pattern)) {
            this.pattern = new StringBuilder();
        }
        if (this.variables == null) {
            this.variables = new ArrayList<UriMatchVariable>();
        }
        return new UriMatchTemplateParser(templateString, this);
    }

    private boolean isRoot() {
        CharSequence rawSegment = null;
        for (UriTemplate.PathSegment segment : this.segments) {
            if (segment.isVariable()) {
                if (segment.isQuerySegment()) continue;
                return false;
            }
            if (rawSegment == null) {
                rawSegment = segment;
                continue;
            }
            return false;
        }
        if (rawSegment == null) {
            return true;
        }
        int len = rawSegment.length();
        return len == 0 || len == 1 && rawSegment.charAt(0) == '/';
    }

    protected static class UriMatchTemplateParser
    extends UriTemplate.UriTemplateParser {
        final UriMatchTemplate matchTemplate;

        protected UriMatchTemplateParser(String templateText, UriMatchTemplate matchTemplate) {
            super(templateText);
            this.matchTemplate = matchTemplate;
        }

        public UriMatchTemplate getMatchTemplate() {
            return this.matchTemplate;
        }

        @Override
        protected void addRawContentSegment(List<UriTemplate.PathSegment> segments, String value, boolean isQuerySegment) {
            this.matchTemplate.pattern.append(Pattern.quote(value));
            super.addRawContentSegment(segments, value, isQuerySegment);
        }

        @Override
        protected void addVariableSegment(List<UriTemplate.PathSegment> segments, String variable, String prefix, String delimiter, boolean encode, boolean repeatPrefix, String modifierStr, char modifierChar, char operator, String previousDelimiter, boolean isQuerySegment) {
            this.matchTemplate.variables.add(new UriMatchVariable(variable, modifierChar, operator));
            StringBuilder pattern = this.matchTemplate.pattern;
            int modLen = modifierStr.length();
            boolean hasModifier = modifierChar == ':' && modLen > 0;
            String operatorPrefix = "";
            String operatorQuantifier = "";
            String variableQuantifier = "+?)";
            String variablePattern = this.getVariablePattern(variable, operator);
            if (hasModifier) {
                char firstChar = modifierStr.charAt(0);
                if (firstChar == '?') {
                    operatorQuantifier = "";
                } else if (modifierStr.chars().allMatch(Character::isDigit)) {
                    variableQuantifier = "{1," + modifierStr + "})";
                } else {
                    char lastChar = modifierStr.charAt(modLen - 1);
                    if (lastChar == '*' || modLen > 1 && lastChar == '?' && (modifierStr.charAt(modLen - 2) == '*' || modifierStr.charAt(modLen - 2) == '+')) {
                        operatorQuantifier = "?";
                    }
                    if (operator == '/' || operator == '.') {
                        variablePattern = "(" + (firstChar == '^' ? modifierStr.substring(1) : modifierStr) + ")";
                    } else {
                        operatorPrefix = "(";
                        variablePattern = (firstChar == '^' ? modifierStr.substring(1) : modifierStr) + ")";
                    }
                    variableQuantifier = "";
                }
            }
            boolean operatorAppended = false;
            switch (operator) {
                case '.': 
                case '/': {
                    pattern.append("(").append(operatorPrefix).append("\\").append(String.valueOf(operator)).append(operatorQuantifier);
                    operatorAppended = true;
                }
                case '+': 
                case '0': {
                    if (!operatorAppended) {
                        pattern.append("(").append(operatorPrefix);
                    }
                    pattern.append(variablePattern).append(variableQuantifier).append(")");
                    break;
                }
            }
            if (operator == '/' || modifierStr.equals("?")) {
                pattern.append("?");
            }
            super.addVariableSegment(segments, variable, prefix, delimiter, encode, repeatPrefix, modifierStr, modifierChar, operator, previousDelimiter, isQuerySegment);
        }

        protected String getVariablePattern(String variable, char operator) {
            if (operator == '+') {
                return "([\\S]";
            }
            return UriMatchTemplate.VARIABLE_MATCH_PATTERN;
        }
    }

    protected static class DefaultUriMatchInfo
    implements UriMatchInfo {
        private final String uri;
        private final Map<String, Object> variableValues;
        private final List<UriMatchVariable> variables;
        private final Map<String, UriMatchVariable> variableMap;

        protected DefaultUriMatchInfo(String uri, Map<String, Object> variableValues, List<UriMatchVariable> variables) {
            this.uri = uri;
            this.variableValues = variableValues;
            this.variables = variables;
            LinkedHashMap<String, UriMatchVariable> vm = new LinkedHashMap<String, UriMatchVariable>(variables.size());
            for (UriMatchVariable variable : variables) {
                vm.put(variable.getName(), variable);
            }
            this.variableMap = Collections.unmodifiableMap(vm);
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public Map<String, Object> getVariableValues() {
            return this.variableValues;
        }

        @Override
        public List<UriMatchVariable> getVariables() {
            return Collections.unmodifiableList(this.variables);
        }

        @Override
        public Map<String, UriMatchVariable> getVariableMap() {
            return this.variableMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultUriMatchInfo that = (DefaultUriMatchInfo)o;
            return this.uri.equals(that.uri) && this.variables.equals(that.variables);
        }

        public String toString() {
            return this.getUri();
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + this.variables.hashCode();
            return result;
        }
    }
}

