/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.exceptions.reporting.DefaultStackTraceFilterer;
import org.grails.exceptions.reporting.StackTraceFilterer;

public class GrailsUtil {
    private static final Log LOG = LogFactory.getLog(GrailsUtil.class);
    private static final boolean LOG_DEPRECATED = Boolean.valueOf(System.getProperty("grails.log.deprecated", String.valueOf(Environment.isDevelopmentMode())));
    private static final StackTraceFilterer stackFilterer = new DefaultStackTraceFilterer();

    private GrailsUtil() {
    }

    public static boolean isDevelopmentEnv() {
        return Environment.getCurrent().equals(Environment.DEVELOPMENT);
    }

    public static String getGrailsVersion() {
        return Environment.getGrailsVersion();
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName) {
        GrailsUtil.deprecated(clazz, methodOrPropName, GrailsUtil.getGrailsVersion());
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName, String version) {
        if (LOG_DEPRECATED) {
            GrailsUtil.deprecated("Property or method [" + methodOrPropName + "] of class [" + clazz.getName() + "] is deprecated in [" + version + "] and will be removed in future releases");
        }
    }

    public static void deprecated(String message) {
        if (LOG_DEPRECATED && LOG.isWarnEnabled()) {
            LOG.warn("[DEPRECATED] " + message);
        }
    }

    public static void warn(String message) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("[WARNING] " + message);
        }
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p) {
        GrailsUtil.printSanitizedStackTrace(t, p, stackFilterer);
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p, StackTraceFilterer stackTraceFilterer) {
        StackTraceElement[] trace;
        t = stackTraceFilterer.filter(t);
        for (StackTraceElement stackTraceElement : trace = t.getStackTrace()) {
            p.println("at " + stackTraceElement.getClassName() + "(" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
    }

    public static void printSanitizedStackTrace(Throwable t) {
        GrailsUtil.printSanitizedStackTrace(t, new PrintWriter(System.err));
    }

    public static Throwable extractRootCause(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static Throwable sanitizeRootCause(Throwable t) {
        return stackFilterer.filter(GrailsUtil.extractRootCause(t));
    }

    public static Throwable deepSanitize(Throwable t) {
        return stackFilterer.filter(t, true);
    }
}

