/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;

public final class DeleteDelta<T>
extends AbstractDelta<T> {
    public DeleteDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.DELETE, original, revised);
    }

    @Override
    protected void applyTo(List<T> target) throws PatchFailedException {
        int position = this.getSource().getPosition();
        int size = this.getSource().size();
        for (int i2 = 0; i2 < size; ++i2) {
            target.remove(position);
        }
    }

    @Override
    protected void restore(List<T> target) {
        int position = this.getTarget().getPosition();
        List lines = this.getSource().getLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            target.add(position + i2, lines.get(i2));
        }
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getSource().getLines() + "]";
    }

    @Override
    public AbstractDelta<T> withChunks(Chunk<T> original, Chunk<T> revised) {
        return new DeleteDelta<T>(original, revised);
    }
}

