/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.util.HashSet;
import org.apache.commons.jcs.utils.discovery.DiscoveredService;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPCleanupRunner
implements Runnable {
    private static final Log log = LogFactory.getLog(UDPCleanupRunner.class);
    private final UDPDiscoveryService discoveryService;
    private static final long DEFAULT_MAX_IDLE_TIME_SECONDS = 180L;
    private final long maxIdleTimeSeconds = 180L;

    public UDPCleanupRunner(UDPDiscoveryService service) {
        this.discoveryService = service;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        HashSet<DiscoveredService> toRemove = new HashSet<DiscoveredService>();
        for (DiscoveredService service : this.discoveryService.getDiscoveredServices()) {
            if (now - service.getLastHearFromTime() <= 180000L) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing service, since we haven't heard from it in 180 seconds.  service = " + service));
            }
            toRemove.add(service);
        }
        for (DiscoveredService service : toRemove) {
            this.discoveryService.removeDiscoveredService(service);
        }
    }
}

