/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.util.Arrays;
import org.apache.datasketches.pig.tuple.DoubleSummarySketchToPercentile;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoubleSummarySketchToPercentileTest {
    @Test
    public void emptySketch() throws Exception {
        DoubleSummarySketchToPercentile func = new DoubleSummarySketchToPercentile();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(Arrays.asList(new DataByteArray(sketch.compact().toByteArray()), 0.0));
        double result = (Double)func.exec(inputTuple);
        Assert.assertEquals((double)result, (double)Double.NaN);
    }

    @Test
    public void normalCase() throws Exception {
        int i;
        DoubleSummarySketchToPercentile func = new DoubleSummarySketchToPercentile();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        int iterations = 100000;
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, (Object)i);
        }
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, (Object)i);
        }
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()), 50.0);
        double result = (Double)func.exec(inputTuple);
        Assert.assertEquals((double)result, (double)iterations, (double)((double)iterations * 0.02));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        DoubleSummarySketchToPercentile func = new DoubleSummarySketchToPercentile();
        func.exec(PigUtil.objectsToTuple(1.0));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void percentileOutOfRange() throws Exception {
        DoubleSummarySketchToPercentile func = new DoubleSummarySketchToPercentile();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        func.exec(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()), 200.0));
    }
}

