/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesState;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesUnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;

abstract class ArrayOfDoublesSketchEvaluator
extends GenericUDAFEvaluator {
    protected static final String NOMINAL_NUM_ENTRIES_FIELD = "nominalEntries";
    protected static final String NUM_VALUES_FIELD = "numValues";
    protected static final String SKETCH_FIELD = "sketch";
    protected PrimitiveObjectInspector nominalNumEntriesInspector_;
    protected StructObjectInspector intermediateInspector_;

    ArrayOfDoublesSketchEvaluator() {
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ArrayOfDoublesState state = (ArrayOfDoublesState)buf;
        ArrayOfDoublesSketch intermediate = state.getResult();
        if (intermediate == null) {
            return null;
        }
        byte[] bytes = intermediate.toByteArray();
        return Arrays.asList(new IntWritable(state.getNominalNumEntries()), new IntWritable(state.getNumValues()), new BytesWritable(bytes));
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        ArrayOfDoublesUnionState state = (ArrayOfDoublesUnionState)buf;
        if (!state.isInitialized()) {
            this.initializeState(state, data);
        }
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(SKETCH_FIELD)));
        state.update(ArrayOfDoublesSketches.wrapSketch((Memory)serializedSketch));
    }

    private void initializeState(ArrayOfDoublesUnionState state, Object data) {
        int nominalNumEntries = ((IntWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(NOMINAL_NUM_ENTRIES_FIELD))).get();
        int numValues = ((IntWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(NUM_VALUES_FIELD))).get();
        state.init(nominalNumEntries, numValues);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ArrayOfDoublesState state = (ArrayOfDoublesState)buf;
        if (state == null) {
            return null;
        }
        ArrayOfDoublesSketch result = state.getResult();
        if (result == null) {
            return null;
        }
        return new BytesWritable(result.toByteArray());
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        ArrayOfDoublesState state = (ArrayOfDoublesState)buf;
        state.reset();
    }
}

