/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class CookieUtils {
    private CookieUtils() {
    }

    public static String createCookie(String name, String value, String path, String domain, long stateTimeToLive) {
        String contextCookie = name + "=" + value;
        if (path != null) {
            contextCookie = contextCookie + ";Path=" + path;
        }
        if (domain != null) {
            contextCookie = contextCookie + ";Domain=" + domain;
        }
        Date expiresDate = new Date(System.currentTimeMillis() + stateTimeToLive);
        String cookieExpires = CookieUtils.getHttpDateFormat().format(expiresDate);
        contextCookie = contextCookie + ";Expires=" + cookieExpires;
        return contextCookie;
    }

    public static SimpleDateFormat getHttpDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        TimeZone tZone = TimeZone.getTimeZone("GMT");
        dateFormat.setTimeZone(tZone);
        return dateFormat;
    }

    public static boolean isStateExpired(long stateCreatedAt, boolean detectExpiredTokens, long expiresAt, long stateTTL) {
        Date currentTime = new Date();
        if (currentTime.after(new Date(stateCreatedAt + stateTTL))) {
            return true;
        }
        return detectExpiredTokens && expiresAt > 0L && currentTime.after(new Date(expiresAt));
    }
}

