/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.Streamable;

public class CorbaPrimitiveHandler
extends CorbaObjectHandler {
    private static final int UNSIGNED_MAX = 256;
    private Object value;
    private String valueAsString;
    private boolean objectSet;
    private Any any;

    public CorbaPrimitiveHandler(QName primName, QName primIdlType, TypeCode primTC, Object primType) {
        super(primName, primIdlType, primTC, primType);
    }

    public Object getValue() {
        return this.value;
    }

    public Any getAny() {
        return this.any;
    }

    @Override
    public void setIntoAny(Any val, CorbaStreamable stream, boolean output) {
        this.any = val;
        if (stream != null) {
            val.insert_Streamable((Streamable)stream);
        }
        if (output && this.value != null) {
            switch (this.typeCode.kind().value()) {
                case 8: {
                    this.any.insert_boolean(((Boolean)this.value).booleanValue());
                    break;
                }
                case 9: {
                    this.any.insert_char(((Character)this.value).charValue());
                    break;
                }
                case 26: {
                    this.any.insert_wchar(((Character)this.value).charValue());
                    break;
                }
                case 10: {
                    this.any.insert_octet(((Byte)this.value).byteValue());
                    break;
                }
                case 2: {
                    this.any.insert_short(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    this.any.insert_ushort((short)((Integer)this.value).intValue());
                    break;
                }
                case 3: {
                    this.any.insert_long(((Integer)this.value).intValue());
                    break;
                }
                case 23: {
                    this.any.insert_longlong(((Long)this.value).longValue());
                    break;
                }
                case 5: {
                    this.any.insert_ulong((int)((Long)this.value).longValue());
                    break;
                }
                case 24: {
                    this.any.insert_ulonglong(((BigInteger)this.value).longValue());
                    break;
                }
                case 6: {
                    this.any.insert_float(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    this.any.insert_double(((Double)this.value).doubleValue());
                    break;
                }
                case 18: {
                    this.any.insert_string((String)this.value);
                    break;
                }
                case 27: {
                    this.any.insert_wstring((String)this.value);
                    break;
                }
            }
        }
    }

    public void setValue(Object obj) {
        this.objectSet = true;
        this.value = obj;
        if (this.any != null && this.value != null) {
            this.setIntoAny(this.any, null, true);
        }
    }

    public String getDataFromValue() {
        if (!this.objectSet && this.any != null) {
            return this.getDataFromAny();
        }
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        String data = "";
        switch (this.typeCode.kind().value()) {
            case 8: {
                data = ((Boolean)this.value).toString();
                break;
            }
            case 9: {
                int charValue = ((Character)this.value).charValue();
                data = Byte.toString((byte)(charValue > 127 ? charValue - 256 : charValue));
                break;
            }
            case 26: {
                data = ((Character)this.value).toString();
                break;
            }
            case 10: {
                data = ((Byte)this.value).toString();
                break;
            }
            case 2: {
                data = ((Short)this.value).toString();
                break;
            }
            case 4: {
                data = ((Integer)this.value).toString();
                break;
            }
            case 3: {
                data = ((Integer)this.value).toString();
                break;
            }
            case 23: {
                data = ((Long)this.value).toString();
                break;
            }
            case 5: {
                data = ((Long)this.value).toString();
                break;
            }
            case 24: {
                data = ((BigInteger)this.value).toString();
                break;
            }
            case 6: {
                if (((Float)this.value).equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    data = "-INF";
                    break;
                }
                if (((Float)this.value).equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                    data = "INF";
                    break;
                }
                data = ((Float)this.value).toString();
                break;
            }
            case 7: {
                if (((Double)this.value).equals(Double.NEGATIVE_INFINITY)) {
                    data = "-INF";
                    break;
                }
                if (((Double)this.value).equals(Double.POSITIVE_INFINITY)) {
                    data = "INF";
                    break;
                }
                data = ((Double)this.value).toString();
                break;
            }
            case 18: 
            case 27: {
                data = (String)this.value;
                break;
            }
            default: {
                data = this.value.toString();
            }
        }
        this.valueAsString = data;
        return data;
    }

    public void setValueFromData(String data) {
        Object obj = null;
        switch (this.typeCode.kind().value()) {
            case 8: {
                obj = Boolean.valueOf(data);
                break;
            }
            case 9: {
                Byte byteValue = Byte.valueOf(data);
                obj = Character.valueOf((char)(byteValue < 0 ? byteValue + 256 : byteValue));
                break;
            }
            case 26: {
                obj = Character.valueOf(data.charAt(0));
                break;
            }
            case 10: {
                obj = Short.valueOf(data).byteValue();
                break;
            }
            case 2: {
                obj = Short.valueOf(data);
                break;
            }
            case 4: {
                obj = Integer.valueOf(data);
                break;
            }
            case 3: {
                obj = Integer.valueOf(data);
                break;
            }
            case 23: {
                obj = Long.valueOf(data);
                break;
            }
            case 5: {
                obj = Long.valueOf(data);
                break;
            }
            case 24: {
                obj = new BigInteger(data);
                break;
            }
            case 6: {
                if ("INF".equals(data)) {
                    obj = Float.valueOf(Float.POSITIVE_INFINITY);
                    break;
                }
                if ("-INF".equals(data)) {
                    obj = Float.valueOf(Float.NEGATIVE_INFINITY);
                    break;
                }
                obj = Float.valueOf(data);
                break;
            }
            case 7: {
                if ("INF".equals(data)) {
                    obj = Double.POSITIVE_INFINITY;
                    break;
                }
                if ("-INF".equals(data)) {
                    obj = Double.NEGATIVE_INFINITY;
                    break;
                }
                obj = Double.valueOf(data);
                break;
            }
            case 18: 
            case 27: {
                obj = data;
                break;
            }
            default: {
                obj = data;
            }
        }
        this.setValue(obj);
    }

    public String getDataFromAny() {
        String data = "";
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        switch (this.typeCode.kind().value()) {
            case 8: {
                data = this.any.extract_boolean() ? "true" : "false";
                break;
            }
            case 9: {
                int charValue = this.any.extract_char();
                data = Byte.toString((byte)(charValue > 127 ? charValue - 256 : charValue));
                break;
            }
            case 26: {
                data = Character.toString(this.any.extract_wchar());
                break;
            }
            case 10: {
                data = Byte.toString(this.any.extract_octet());
                break;
            }
            case 2: {
                data = Short.toString(this.any.extract_short());
                break;
            }
            case 4: {
                data = Integer.toString(this.any.extract_ushort());
                break;
            }
            case 3: {
                data = Integer.toString(this.any.extract_long());
                break;
            }
            case 23: {
                data = Long.toString(this.any.extract_longlong());
                break;
            }
            case 5: {
                long l = this.any.extract_ulong();
                data = Long.toString(l & 0xFFFFFFFFL);
                break;
            }
            case 24: {
                data = BigInteger.valueOf(this.any.extract_ulonglong()).toString();
                break;
            }
            case 6: {
                Float f = Float.valueOf(this.any.extract_float());
                if (f.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    data = "-INF";
                    break;
                }
                if (f.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                    data = "INF";
                    break;
                }
                data = f.toString();
                break;
            }
            case 7: {
                Double d = this.any.extract_double();
                if (d.equals(Double.NEGATIVE_INFINITY)) {
                    data = "-INF";
                    break;
                }
                if (d.equals(Double.POSITIVE_INFINITY)) {
                    data = "INF";
                    break;
                }
                data = d.toString();
                break;
            }
            case 18: {
                data = this.any.extract_string();
                break;
            }
            case 27: {
                data = this.any.extract_wstring();
                break;
            }
            default: {
                throw new RuntimeException("Unknown tc: " + String.valueOf(this.typeCode));
            }
        }
        this.valueAsString = data;
        return data;
    }

    @Override
    public void clear() {
        this.value = null;
        this.objectSet = false;
        this.valueAsString = null;
    }
}

