/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.PrimaryActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingPrimaryActivation;

public class ReplicatedPolicy
implements HAPolicy<PrimaryActivation> {
    private boolean checkForPrimaryServer = ActiveMQDefaultConfiguration.isDefaultCheckForActiveServer();
    private String groupName = null;
    private String clusterName;
    private int maxSavedReplicatedJournalsSize = ActiveMQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize();
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private boolean allowAutoFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private boolean voteOnReplicationFailure;
    private int quorumSize;
    private int voteRetries;
    private long voteRetryWait;
    private long retryReplicationWait;
    private ReplicaPolicy replicaPolicy;
    private final NetworkHealthCheck networkHealthCheck;
    private final int quorumVoteWait;

    public ReplicatedPolicy(NetworkHealthCheck networkHealthCheck, int quorumVoteWait) {
        this.replicaPolicy = new ReplicaPolicy(networkHealthCheck, this, quorumVoteWait);
        this.networkHealthCheck = networkHealthCheck;
        this.quorumVoteWait = quorumVoteWait;
    }

    public ReplicatedPolicy(boolean checkForPrimaryServer, String groupName, String clusterName, int maxSavedReplicatedJournalsSize, long initialReplicationSyncTimeout, NetworkHealthCheck networkHealthCheck, boolean voteOnReplicationFailure, int quorumSize, int voteRetries, long voteRetryWait, int quorumVoteWait, long retryReplicationWait) {
        this.checkForPrimaryServer = checkForPrimaryServer;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.networkHealthCheck = networkHealthCheck;
        this.voteOnReplicationFailure = voteOnReplicationFailure;
        this.quorumSize = quorumSize;
        this.voteRetries = voteRetries;
        this.voteRetryWait = voteRetryWait;
        this.quorumVoteWait = quorumVoteWait;
        this.retryReplicationWait = retryReplicationWait;
    }

    public ReplicatedPolicy(boolean checkForPrimaryServer, boolean allowAutoFailBack, long initialReplicationSyncTimeout, String groupName, String clusterName, ReplicaPolicy replicaPolicy, NetworkHealthCheck networkHealthCheck, boolean voteOnReplicationFailure, int quorumSize, int voteRetries, long voteRetryWait, int quorumVoteWait) {
        this.checkForPrimaryServer = checkForPrimaryServer;
        this.clusterName = clusterName;
        this.groupName = groupName;
        this.allowAutoFailBack = allowAutoFailBack;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.replicaPolicy = replicaPolicy;
        this.networkHealthCheck = networkHealthCheck;
        this.voteOnReplicationFailure = voteOnReplicationFailure;
        this.quorumSize = quorumSize;
        this.quorumVoteWait = quorumVoteWait;
    }

    public boolean isCheckForPrimaryServer() {
        return this.checkForPrimaryServer;
    }

    public void setCheckForPrimaryServer(boolean checkForPrimaryServer) {
        this.checkForPrimaryServer = checkForPrimaryServer;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public void setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ReplicaPolicy getReplicaPolicy() {
        if (this.replicaPolicy == null) {
            this.replicaPolicy = new ReplicaPolicy(this.networkHealthCheck, this, this.quorumVoteWait);
            this.replicaPolicy.setQuorumSize(this.quorumSize);
            this.replicaPolicy.setVoteOnReplicationFailure(this.voteOnReplicationFailure);
            this.replicaPolicy.setVoteRetries(this.voteRetries);
            this.replicaPolicy.setVoteRetryWait(this.voteRetryWait);
            this.replicaPolicy.setretryReplicationWait(this.retryReplicationWait);
            this.replicaPolicy.setMaxSavedReplicatedJournalsSize(this.maxSavedReplicatedJournalsSize);
            if (this.clusterName != null && !this.clusterName.isEmpty()) {
                this.replicaPolicy.setClusterName(this.clusterName);
            }
            if (this.groupName != null && !this.groupName.isEmpty()) {
                this.replicaPolicy.setGroupName(this.groupName);
            }
        }
        return this.replicaPolicy;
    }

    public void setReplicaPolicy(ReplicaPolicy replicaPolicy) {
        this.replicaPolicy = replicaPolicy;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    public boolean isVoteOnReplicationFailure() {
        return this.voteOnReplicationFailure;
    }

    @Override
    public PrimaryActivation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new SharedNothingPrimaryActivation(server, this);
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public void setQuorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
    }

    public int getQuorumVoteWait() {
        return this.quorumVoteWait;
    }

    public long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }
}

