/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AuthorizationRequestFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtConsumer;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class JwtRequestCodeFilter
extends OAuthJoseJwtConsumer
implements AuthorizationRequestFilter {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwtRequestCodeFilter.class);
    private static final String REQUEST_URI_CONTENT_TYPE = "application/oauth-authz-req+jwt";
    private static final String REQUEST_PARAM = "request";
    private static final String REQUEST_URI_PARAM = "request_uri";
    private boolean verifyWithClientCertificates;
    private String issuer;
    private JsonMapObjectReaderWriter jsonHandler = new JsonMapObjectReaderWriter();

    @Override
    public MultivaluedMap<String, String> process(MultivaluedMap<String, String> params, UserSubject endUser, Client client) {
        String requestToken = (String)params.getFirst((Object)REQUEST_PARAM);
        String requestUri = (String)params.getFirst((Object)REQUEST_URI_PARAM);
        if (requestToken == null) {
            if (this.isRequestUriValid(client, requestUri)) {
                requestToken = (String)WebClient.create((String)requestUri).accept(new String[]{REQUEST_URI_CONTENT_TYPE}).get(String.class);
            }
        } else if (requestUri != null) {
            LOG.warning("It is not valid to specify both a request and request_uri value");
            throw new SecurityException();
        }
        if (requestToken != null) {
            String iss;
            JweDecryptionProvider theDecryptor = super.getInitializedDecryptionProvider(client.getClientSecret());
            JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier(client);
            JwtToken jwt = this.getJwtToken(requestToken, theDecryptor, theSigVerifier);
            JwtClaims claims = jwt.getClaims();
            String string = iss = this.issuer != null ? this.issuer : client.getClientId();
            if (!iss.equals(claims.getIssuer())) {
                throw new SecurityException();
            }
            if (claims.getClaim("client_id") != null && !claims.getStringProperty("client_id").equals(client.getClientId())) {
                throw new SecurityException();
            }
            String tokenResponseType = (String)claims.getClaim("response_type");
            if (tokenResponseType != null && !tokenResponseType.equals(params.getFirst((Object)"response_type"))) {
                throw new SecurityException();
            }
            MetadataMap newParams = new MetadataMap(params);
            Map claimsMap = claims.asMap();
            for (Map.Entry entry : claimsMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map map = CastUtils.cast((Map)((Map)value));
                    value = this.jsonHandler.toJson(map);
                } else if (value instanceof List) {
                    List list = CastUtils.cast((List)((List)value));
                    value = this.jsonHandler.toJson(list);
                }
                newParams.putSingle((Object)key, (Object)value.toString());
            }
            return newParams;
        }
        return params;
    }

    protected boolean isRequestUriValid(Client client, String requestUri) {
        return false;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier(Client c) {
        if (this.verifyWithClientCertificates) {
            X509Certificate cert = (X509Certificate)CryptoUtils.decodeCertificate((String)c.getApplicationCertificates().get(0));
            return JwsUtils.getPublicKeySignatureVerifier((X509Certificate)cert, (SignatureAlgorithm)SignatureAlgorithm.RS256);
        }
        return super.getInitializedSignatureVerifier(c.getClientSecret());
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setVerifyWithClientCertificates(boolean verifyWithClientCertificates) {
        this.verifyWithClientCertificates = verifyWithClientCertificates;
    }
}

