/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import org.apache.cxf.binding.corba.types.AbstractStartEndEventProducer;
import org.apache.cxf.binding.corba.types.CorbaArrayEventProducer;
import org.apache.cxf.binding.corba.types.CorbaArrayHandler;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveArrayEventProducer;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveSequenceEventProducer;
import org.apache.cxf.binding.corba.types.CorbaSequenceEventProducer;
import org.apache.cxf.binding.corba.types.CorbaSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaStructHandler;
import org.apache.cxf.binding.corba.wsdl.Abstractanonsequence;
import org.apache.cxf.binding.corba.wsdl.Abstractsequence;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaStructEventProducer
extends AbstractStartEndEventProducer {
    public CorbaStructEventProducer(CorbaObjectHandler h, ServiceInfo service, ORB orbRef) {
        CorbaStructHandler handler = (CorbaStructHandler)h;
        this.name = handler.getName();
        this.iterator = handler.members.iterator();
        this.serviceInfo = service;
        this.orb = orbRef;
        if (handler.members.isEmpty() && handler.getSimpleName().equals(handler.getIdlType().getLocalPart() + "_f")) {
            this.state = this.states.length;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int next() {
        int event = this.states[this.state];
        if (event != 0) {
            ++this.state;
            return event;
        } else {
            if (this.currentEventProducer != null && this.currentEventProducer.hasNext()) {
                return this.currentEventProducer.next();
            }
            if (this.iterator.hasNext()) {
                boolean primitivearray;
                CorbaObjectHandler obj = (CorbaObjectHandler)this.iterator.next();
                boolean primitiveSequence = obj instanceof CorbaSequenceHandler && !CorbaHandlerUtils.isOctets(obj.getType());
                boolean bl = primitivearray = obj instanceof CorbaArrayHandler && !CorbaHandlerUtils.isOctets(obj.getType());
                if (primitiveSequence || primitivearray) {
                    boolean wrapped = true;
                    if (obj.getType() instanceof Abstractanonsequence) {
                        wrapped = ((Abstractanonsequence)obj.getType()).isWrapped();
                    } else if (obj.getType() instanceof Abstractsequence) {
                        wrapped = ((Abstractsequence)obj.getType()).isWrapped();
                    }
                    this.currentEventProducer = obj instanceof CorbaSequenceHandler ? (wrapped ? new CorbaSequenceEventProducer(obj, this.serviceInfo, this.orb) : new CorbaPrimitiveSequenceEventProducer(obj, this.serviceInfo, this.orb)) : (wrapped ? new CorbaArrayEventProducer(obj, this.serviceInfo, this.orb) : new CorbaPrimitiveArrayEventProducer(obj, this.serviceInfo, this.orb));
                } else {
                    this.currentEventProducer = obj.getSimpleName().equals(obj.getIdlType().getLocalPart() + "_f") ? CorbaHandlerUtils.getTypeEventProducer(obj, this.serviceInfo, this.orb) : CorbaHandlerUtils.getTypeEventProducer(obj, this.serviceInfo, this.orb);
                }
                if (this.currentEventProducer.hasNext()) {
                    return this.currentEventProducer.next();
                }
                this.currentEventProducer = null;
                return this.next();
            }
            event = this.states[++this.state];
            ++this.state;
            this.currentEventProducer = null;
        }
        return event;
    }
}

