/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.creadur.tentacles.Licenses;
import org.apache.creadur.tentacles.Platform;
import org.apache.creadur.tentacles.TentaclesResources;

public enum LicenseType {
    ASL_2_0("asl-2.0"),
    CPL_1_0("cpl-1.0"),
    CDDL_1_0("cddl-1.0");

    private final String resourceName;
    private final String resourcePath;

    public static Licenses loadLicensesFrom(Platform platform) throws IOException {
        ConcurrentHashMap<String, String> licenses = new ConcurrentHashMap<String, String>();
        for (LicenseType type : LicenseType.values()) {
            type.putTextInto(licenses, platform.getTentaclesResources());
        }
        return new Licenses(licenses, platform);
    }

    private LicenseType(String resourceName) {
        this.resourceName = resourceName;
        this.resourcePath = "licenses/" + this.getResourceName() + ".txt";
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String readText(TentaclesResources tentaclesResources) throws IOException {
        return tentaclesResources.readText(this.getResourcePath()).trim();
    }

    public void putTextInto(Map<String, String> licenseTextByName, TentaclesResources tentaclesResources) throws IOException {
        licenseTextByName.put(this.getResourceName(), this.readText(tentaclesResources));
    }
}

