/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.XmlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class XmlStringLookupTest {
    private static final Path CURRENT_PATH = Paths.get("", new String[0]);
    private static final Path ABSENT_PATH = Paths.get("does not exist at all", new String[0]);
    private static final String DOC_RELATIVE = "src/test/resources/org/apache/commons/text/document.xml";
    private static final String DOC_ROOT = "/document.xml";

    XmlStringLookupTest() {
    }

    static void assertLookup(StringLookup xmlStringLookup) {
        Assertions.assertNotNull((Object)xmlStringLookup);
        Assertions.assertInstanceOf(XmlStringLookup.class, (Object)xmlStringLookup);
        Assertions.assertEquals((Object)"Hello World!", (Object)xmlStringLookup.apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertNull((Object)xmlStringLookup.apply(null));
    }

    @Test
    void testBadXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.apply("docName"));
    }

    @Test
    void testMissingXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.apply("src/test/resources/org/apache/commons/text/document.xml:!JUNK!"));
    }

    @Test
    void testNoFeatures() {
        String xpath = "/root/path/to/node";
        Assertions.assertEquals((Object)"Hello World!", (Object)new XmlStringLookup(new HashMap(), new Path[0]).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertEquals((Object)"Hello World!", (Object)new XmlStringLookup(new HashMap(), new Path[]{CURRENT_PATH}).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertEquals((Object)"Hello World!", (Object)new XmlStringLookup(new HashMap(), new Path[]{CURRENT_PATH, ABSENT_PATH}).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertEquals((Object)"Hello World!", (Object)new XmlStringLookup(new HashMap(), new Path[]{ABSENT_PATH, CURRENT_PATH}).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(new HashMap(), new Path[]{ABSENT_PATH}).apply("/document.xml:/root/path/to/node"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(new HashMap(), new Path[]{CURRENT_PATH}).apply("/document.xml:/root/path/to/node"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(new HashMap(), new Path[]{ABSENT_PATH, CURRENT_PATH}).apply("/document.xml:/root/path/to/node"));
    }

    @Test
    void testNoFeaturesDefault() {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(1);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        XmlStringLookupTest.assertLookup((StringLookup)new XmlStringLookup(features, new Path[0]));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)XmlStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testOne() {
        XmlStringLookupTest.assertLookup((StringLookup)XmlStringLookup.INSTANCE);
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)XmlStringLookup.INSTANCE.toString().isEmpty());
    }
}

