/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import java.security.SecureRandom;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.source64.XoRoShiRo1024PlusPlus;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.simple.internal.MixFunctions;

public final class SeedFactory {
    private static final int XO_RO_SHI_RO_1024_STATE_SIZE = 16;
    private static final int INT_ARRAY_BLOCK_SIZE = 8;
    private static final int LONG_ARRAY_BLOCK_SIZE = 4;
    private static final ReentrantLock LOCK = new ReentrantLock(false);
    private static final UniformRandomProvider SEED_GENERATOR;

    private SeedFactory() {
    }

    public static int createInt() {
        LOCK.lock();
        try {
            int n = SEED_GENERATOR.nextInt();
            return n;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static long createLong() {
        LOCK.lock();
        try {
            long l = SEED_GENERATOR.nextLong();
            return l;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static int[] createIntArray(int n) {
        return SeedFactory.createIntArray(n, 0, Math.min(n, 1));
    }

    static int[] createIntArray(int n, int from, int to) {
        int[] seed = new int[n];
        int blockSize = 8 * (n / 8);
        int i = 0;
        while (i < blockSize) {
            int end = i + 8;
            SeedFactory.fillIntArray(seed, i, end);
            i = end;
        }
        if (i != n) {
            SeedFactory.fillIntArray(seed, i, n);
        }
        SeedFactory.ensureNonZero(seed, from, to);
        return seed;
    }

    public static long[] createLongArray(int n) {
        return SeedFactory.createLongArray(n, 0, Math.min(n, 1));
    }

    static long[] createLongArray(int n, int from, int to) {
        long[] seed = new long[n];
        int blockSize = 4 * (n / 4);
        int i = 0;
        while (i < blockSize) {
            int end = i + 4;
            SeedFactory.fillLongArray(seed, i, end);
            i = end;
        }
        if (i != n) {
            SeedFactory.fillLongArray(seed, i, n);
        }
        SeedFactory.ensureNonZero(seed, from, to);
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillIntArray(int[] array, int start, int end) {
        LOCK.lock();
        try {
            for (int i = start; i < end; ++i) {
                array[i] = SEED_GENERATOR.nextInt();
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillLongArray(long[] array, int start, int end) {
        LOCK.lock();
        try {
            for (int i = start; i < end; ++i) {
                array[i] = SEED_GENERATOR.nextLong();
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    static byte[] createByteArray(UniformRandomProvider source, int n, int from, int to) {
        byte[] seed = new byte[n];
        source.nextBytes(seed);
        SeedFactory.ensureNonZero(seed, from, to, source);
        return seed;
    }

    static void ensureNonZero(int[] seed, int from, int to) {
        if (from >= to) {
            return;
        }
        for (int i = from; i < to; ++i) {
            if (seed[i] == 0) continue;
            return;
        }
        int x = SeedFactory.createInt() << 1;
        for (int i = from; i < to; ++i) {
            seed[i] = MixFunctions.murmur3(x -= 1640531527);
        }
    }

    static void ensureNonZero(long[] seed, int from, int to) {
        if (from >= to) {
            return;
        }
        for (int i = from; i < to; ++i) {
            if (seed[i] == 0L) continue;
            return;
        }
        long x = SeedFactory.createLong() << 1;
        for (int i = from; i < to; ++i) {
            seed[i] = MixFunctions.stafford13(x += -7046029254386353131L);
        }
    }

    static void ensureNonZero(byte[] seed, int from, int to, UniformRandomProvider source) {
        long v;
        if (from >= to) {
            return;
        }
        for (int i = from; i < to; ++i) {
            if (seed[i] == 0) continue;
            return;
        }
        long x = source.nextLong() << 1;
        int len = to - from & 0xFFFFFFF8;
        int end = from + len;
        int i = from;
        while (i < end) {
            v = MixFunctions.stafford13(x += -7046029254386353131L);
            for (int j = 0; j < 8; ++j) {
                seed[i++] = (byte)v;
                v >>>= 8;
            }
        }
        if (i < to) {
            v = MixFunctions.stafford13(x + -7046029254386353131L);
            if (len == 0) {
                v = Long.rotateRight(v, Long.numberOfTrailingZeros(v) & 0xFFFFFFF8);
            }
            while (i < to) {
                seed[i++] = (byte)v;
                v >>>= 8;
            }
        }
    }

    static long ensureNonZero(RandomLongSource source, long value) {
        long result = value;
        while (result == 0L) {
            result = source.next();
        }
        return result;
    }

    static {
        SecureRandom seedGen = new SecureRandom();
        byte[] bytes = new byte[128];
        seedGen.nextBytes(bytes);
        long[] seed = NumberFactory.makeLongArray((byte[])bytes);
        SplitMix64 rng = new SplitMix64(seed[0]);
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedFactory.ensureNonZero((RandomLongSource)rng, seed[i]);
        }
        SEED_GENERATOR = new XoRoShiRo1024PlusPlus(seed);
    }
}

