/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.util.TypeUtils;

public class MethodLookupUtils {
    private static final int NO_MATCH = 0;
    private static final int APPROXIMATE_MATCH = 1;
    private static final int EXACT_MATCH = 2;

    public static Constructor lookupConstructor(Class targetClass, Object[] parameters) {
        Constructor<?>[] constructors;
        boolean tryExact = true;
        int count = parameters == null ? 0 : parameters.length;
        Class[] types = new Class[count];
        for (int i = 0; i < count; ++i) {
            Object param = parameters[i];
            if (param != null) {
                types[i] = param.getClass();
                continue;
            }
            types[i] = null;
            tryExact = false;
        }
        Constructor<Object> constructor = null;
        if (tryExact) {
            try {
                constructor = targetClass.getConstructor(types);
                if (constructor != null) {
                    return constructor;
                }
            }
            catch (NoSuchMethodException param) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        for (Constructor<?> constructor2 : constructors = targetClass.getConstructors()) {
            int match = MethodLookupUtils.matchParameterTypes(constructor2.getParameterTypes(), parameters);
            if (match == 0) continue;
            if (match > currentMatch) {
                constructor = constructor2;
                currentMatch = match;
                ambiguous = false;
                continue;
            }
            if (match != currentMatch) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new JXPathException("Ambiguous constructor " + Arrays.asList(parameters));
        }
        return constructor;
    }

    public static Method lookupMethod(Class targetClass, String name, Object[] parameters) {
        Method[] methods;
        if (parameters == null || parameters.length < 1 || parameters[0] == null) {
            return null;
        }
        if (MethodLookupUtils.matchType(targetClass, parameters[0]) == 0) {
            return null;
        }
        targetClass = TypeUtils.convert(parameters[0], targetClass).getClass();
        boolean tryExact = true;
        int count = parameters.length - 1;
        Class[] types = new Class[count];
        Object[] arguments = new Object[count];
        for (int i = 0; i < count; ++i) {
            Object param;
            arguments[i] = param = parameters[i + 1];
            if (param != null) {
                types[i] = param.getClass();
                continue;
            }
            types[i] = null;
            tryExact = false;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && !Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException param) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        for (Method method2 : methods = targetClass.getMethods()) {
            int match;
            if (Modifier.isStatic(method2.getModifiers()) || !method2.getName().equals(name) || (match = MethodLookupUtils.matchParameterTypes(method2.getParameterTypes(), arguments)) == 0) continue;
            if (match > currentMatch) {
                method = method2;
                currentMatch = match;
                ambiguous = false;
                continue;
            }
            if (match != currentMatch) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new JXPathException("Ambiguous method call: " + name);
        }
        return method;
    }

    public static Method lookupStaticMethod(Class targetClass, String name, Object[] parameters) {
        Method[] methods;
        boolean tryExact = true;
        int count = parameters == null ? 0 : parameters.length;
        Class[] types = new Class[count];
        for (int i = 0; i < count; ++i) {
            Object param = parameters[i];
            if (param != null) {
                types[i] = param.getClass();
                continue;
            }
            types[i] = null;
            tryExact = false;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException param) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        for (Method method2 : methods = targetClass.getMethods()) {
            int match;
            if (!Modifier.isStatic(method2.getModifiers()) || !method2.getName().equals(name) || (match = MethodLookupUtils.matchParameterTypes(method2.getParameterTypes(), parameters)) == 0) continue;
            if (match > currentMatch) {
                method = method2;
                currentMatch = match;
                ambiguous = false;
                continue;
            }
            if (match != currentMatch) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new JXPathException("Ambiguous method call: " + name);
        }
        return method;
    }

    private static int matchParameterTypes(Class[] types, Object[] parameters) {
        int length;
        int pi = 0;
        if (types.length >= 1 && ExpressionContext.class.isAssignableFrom(types[0])) {
            ++pi;
        }
        int n = length = parameters == null ? 0 : parameters.length;
        if (types.length != length + pi) {
            return 0;
        }
        int totalMatch = 2;
        for (int i = 0; i < length; ++i) {
            int match = MethodLookupUtils.matchType(types[i + pi], parameters[i]);
            if (match == 0) {
                return 0;
            }
            if (match >= totalMatch) continue;
            totalMatch = match;
        }
        return totalMatch;
    }

    private static int matchType(Class expected, Object object) {
        if (object == null) {
            return 1;
        }
        Class<?> actual = object.getClass();
        if (expected.equals(actual)) {
            return 2;
        }
        if (expected.isAssignableFrom(actual)) {
            return 2;
        }
        if (TypeUtils.canConvert(object, expected)) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public MethodLookupUtils() {
    }
}

