/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.servlet;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockPageContext;
import com.mockrunner.mock.web.MockServletConfig;
import com.mockrunner.mock.web.MockServletContext;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.servlet.JXPathServletContexts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JXPathServletContextTest {
    private void checkPointerIterator(JXPathContext context) {
        Iterator it = context.iteratePointers("/*");
        Assertions.assertTrue((boolean)it.hasNext(), (String)"Empty context");
        while (it.hasNext()) {
            Pointer pointer = (Pointer)it.next();
            Assertions.assertNotNull((Object)pointer, (String)"null pointer");
            Assertions.assertNotNull((Object)pointer.asPath(), (String)"null path");
        }
    }

    private ServletContext getServletContext() {
        MockServletContext context = new MockServletContext();
        context.setAttribute("app", (Object)"OK");
        return context;
    }

    @Test
    public void testPageContext() {
        MockServletContext servletContext = new MockServletContext();
        servletContext.setAttribute("app", (Object)"app");
        MockServletConfig servletConfig = new MockServletConfig();
        servletConfig.setServletContext((ServletContext)servletContext);
        MockHttpSession session = new MockHttpSession();
        session.setupServletContext((ServletContext)servletContext);
        session.setAttribute("session", (Object)"session");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("request", (Object)"request");
        request.setSession((HttpSession)session);
        MockPageContext pageContext = new MockPageContext();
        pageContext.setServletConfig((ServletConfig)servletConfig);
        pageContext.setServletRequest((ServletRequest)request);
        pageContext.setAttribute("page", (Object)"page");
        Assertions.assertSame((Object)session, (Object)request.getSession(), (String)"Request session");
        JXPathContext context = JXPathServletContexts.getPageContext((PageContext)pageContext);
        context.setLenient(true);
        this.checkPointerIterator(context);
        Assertions.assertEquals((Object)"page", (Object)context.getValue("page"), (String)"Page Scope");
        Assertions.assertEquals((Object)"request", (Object)context.getValue("request"), (String)"Request Scope");
        Assertions.assertEquals((Object)"session", (Object)context.getValue("session"), (String)"Session Scope");
        Assertions.assertEquals((Object)"app", (Object)context.getValue("app"), (String)"Application Scope");
        Assertions.assertEquals((Object)"page", (Object)context.getValue("$page/page"), (String)"Explicit Page Scope");
        Assertions.assertEquals((Object)"request", (Object)context.getValue("$request/request"), (String)"Explicit Request Scope");
        Assertions.assertEquals((Object)"session", (Object)context.getValue("$session/session"), (String)"Explicit Session Scope");
        Assertions.assertEquals((Object)"app", (Object)context.getValue("$application/app"), (String)"Explicit Application Scope");
        Iterator it = context.iteratePointers("$page/*");
        Assertions.assertTrue((boolean)it.hasNext(), (String)"element not found");
        it.next();
        it.next();
        Assertions.assertFalse((boolean)it.hasNext(), (String)"too many elements");
        context.setValue("/foo1", (Object)"bar1");
        Assertions.assertEquals((Object)"bar1", (Object)context.getValue("/foo1"), (String)"Context property");
        context.setValue("$page/foo2", (Object)"bar2");
        Assertions.assertEquals((Object)"bar2", (Object)context.getValue("$page/foo2"), (String)"Context property");
    }

    @Test
    public void testServletContext() {
        ServletContext context = this.getServletContext();
        JXPathContext appContext = JXPathServletContexts.getApplicationContext((ServletContext)context);
        Assertions.assertSame((Object)appContext, (Object)JXPathServletContexts.getApplicationContext((ServletContext)context), (String)"Cached context not property returned");
        Assertions.assertEquals((Object)"OK", (Object)appContext.getValue("app"), (String)"Application Context");
        this.checkPointerIterator(appContext);
        appContext.setValue("/foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)appContext.getValue("/foo"), (String)"Context property");
        Variables variables = appContext.getVariables();
        Assertions.assertNotNull((Object)variables.getVariable("application"), (String)"$application variable");
        Assertions.assertNull((Object)variables.getVariable("$foo"), (String)"$foo variable");
    }

    @Test
    public void testServletRequest() {
        ServletContext context = this.getServletContext();
        MockHttpSession session = new MockHttpSession();
        session.setupServletContext(context);
        session.setUpIsNew(true);
        Integer count = 10;
        session.setAttribute("count", (Object)count);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession((HttpSession)session);
        request.setAttribute("attr", (Object)"OK");
        request.setupAddParameter("parm", "OK");
        request.setupAddParameter("multiparam", new String[]{"value1", "value2"});
        request.setupAddParameter("emptyparam", new String[0]);
        Assertions.assertSame((Object)session, (Object)request.getSession(), (String)"Request session");
        JXPathContext reqContext = JXPathServletContexts.getRequestContext((ServletRequest)request, (ServletContext)context);
        Assertions.assertSame((Object)reqContext, (Object)JXPathServletContexts.getRequestContext((ServletRequest)request, (ServletContext)context), (String)"Cached context not property returned");
        JXPathContext sessionContext = JXPathServletContexts.getSessionContext((HttpSession)session, (ServletContext)context);
        Assertions.assertSame((Object)sessionContext, (Object)JXPathServletContexts.getSessionContext((HttpSession)session, (ServletContext)context), (String)"Cached context not property returned");
        Assertions.assertEquals((Object)"OK", (Object)reqContext.getValue("attr"), (String)"Request Context Attribute");
        Assertions.assertEquals((Object)"OK", (Object)reqContext.getValue("parm"), (String)"Request Context Parameter");
        Assertions.assertTrue((boolean)reqContext.getValue("multiparam").getClass().isArray(), (String)"Request Context Parameter (Array)");
        Assertions.assertNull((Object)reqContext.getValue("emptyparam"), (String)"Request Context Parameter (Empty)");
        Assertions.assertEquals((Object)count, (Object)sessionContext.getValue("count"), (String)"Session Context Parameter");
        Assertions.assertEquals((Object)"OK", (Object)reqContext.getValue("app"), (String)"Application Context via Request Context");
        Assertions.assertEquals((Object)count, (Object)reqContext.getValue("count"), (String)"Session Context via Request Context");
        Assertions.assertEquals((Object)"OK", (Object)sessionContext.getValue("app"), (String)"Application Context via Session Context");
        this.checkPointerIterator(reqContext);
        this.checkPointerIterator(sessionContext);
        reqContext.setValue("/foo1", (Object)"bar1");
        Assertions.assertEquals((Object)"bar1", (Object)reqContext.getValue("/foo1"), (String)"Context property");
        sessionContext.setValue("/foo2", (Object)"bar2");
        Assertions.assertEquals((Object)"bar2", (Object)sessionContext.getValue("/foo2"), (String)"Context property");
    }

    @Test
    public void testServletRequestWithoutSession() {
        ServletContext context = this.getServletContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        JXPathContext reqContext = JXPathServletContexts.getRequestContext((ServletRequest)request, (ServletContext)context);
        Assertions.assertEquals((Object)"OK", (Object)reqContext.getValue("app"), (String)"Application Context via Request Context");
    }
}

