/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.test;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.junit.jupiter.api.Assertions;

public class ThrowOnFlushAndCloseOutputStream
extends ProxyOutputStream {
    private boolean throwOnFlush;
    private boolean throwOnClose;

    public ThrowOnFlushAndCloseOutputStream(OutputStream proxy, boolean throwOnFlush, boolean throwOnClose) {
        super(proxy);
        this.throwOnFlush = throwOnFlush;
        this.throwOnClose = throwOnClose;
    }

    public void close() throws IOException {
        if (this.throwOnClose) {
            Assertions.fail((String)(((Object)((Object)this)).getClass().getSimpleName() + ".close() called."));
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.throwOnFlush) {
            Assertions.fail((String)(((Object)((Object)this)).getClass().getSimpleName() + ".flush() called."));
        }
        super.flush();
    }

    public void off() {
        this.throwOnFlush = false;
        this.throwOnClose = false;
    }
}

