/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ReversedLinesFileReaderParamBlockSizeTest {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String ISO_8859_1 = StandardCharsets.ISO_8859_1.name();
    private static final String TEST_LINE = "A Test Line. Special chars: \u00c4\u00e4\u00dc\u00fc\u00d6\u00f6\u00df \u00c3\u00e1\u00e9\u00ed\u00ef\u00e7\u00f1\u00c2 \u00a9\u00b5\u00a5\u00a3\u00b1\u00b2\u00ae";
    private static final String TEST_LINE_SHIFT_JIS1 = "Hiragana letters: \u3041\u3042\u3043\u3044\u3045";
    private static final String TEST_LINE_SHIFT_JIS2 = "Kanji letters: \u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_WINDOWS_31J_1 = "\u3041\u3042\u3043\u3044\u3045";
    private static final String TEST_LINE_WINDOWS_31J_2 = "\u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_GBK_1 = "\u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_GBK_2 = "\u7b80\u4f53\u4e2d\u6587";
    private static final String TEST_LINE_X_WINDOWS_949_1 = "\ud55c\uad6d\uc5b4";
    private static final String TEST_LINE_X_WINDOWS_949_2 = "\ub300\ud55c\ubbfc\uad6d";
    private static final String TEST_LINE_X_WINDOWS_950_1 = "\u660e\u8f38\u5b50\u4eac";
    private static final String TEST_LINE_X_WINDOWS_950_2 = "\u7e41\u9ad4\u4e2d\u6587";
    private ReversedLinesFileReader reversedLinesFileReader;

    ReversedLinesFileReaderParamBlockSizeTest() {
    }

    static void assertEqualsAndNoLineBreaks(String expected, String actual) {
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(expected, actual, null);
    }

    static void assertEqualsAndNoLineBreaks(String expected, String actual, Supplier<String> messageSupplier) {
        if (actual != null) {
            Assertions.assertFalse((boolean)actual.contains(StandardLineSeparator.LF.getString()), (String)("Line contains \\n: line=" + actual));
            Assertions.assertFalse((boolean)actual.contains(StandardLineSeparator.CR.getString()), (String)("Line contains \\r: line=" + actual));
        }
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public static IntStream blockSizes() {
        return IntStream.of(1, 3, 8, 10, 256, 4096, 8192);
    }

    private void assertFileWithShrinkingTestLines(ReversedLinesFileReader reversedLinesFileReader) throws IOException {
        AtomicInteger count = new AtomicInteger();
        reversedLinesFileReader.forEach(line -> ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE.substring(0, count.incrementAndGet()), line, () -> "Line " + count + " is not matching"));
    }

    @AfterEach
    public void closeReader() {
        try {
            if (this.reversedLinesFileReader != null) {
                this.reversedLinesFileReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testEmptyFile(int blockSize) throws URISyntaxException, IOException {
        File testFileEmpty = TestResources.getFile("/test-file-empty.bin");
        try (ReversedLinesFileReader reader = new ReversedLinesFileReader(testFileEmpty, blockSize, UTF_8);){
            Assertions.assertNull((Object)reader.readLine());
        }
        reader = ((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)((ReversedLinesFileReader.Builder)ReversedLinesFileReader.builder().setFile(testFileEmpty)).setBufferSize(blockSize)).setCharset(UTF_8)).get();
        try {
            Assertions.assertNull((Object)reader.readLine());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    void testFileSizeIsExactMultipleOfBlockSize() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, 10, ISO_8859_1);
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("987654321", this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("123456789", this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testGBK(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileGBK = TestResources.getFile("/test-file-gbk.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileGBK, testParamBlockSize, "GBK");
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_GBK_2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("\u660e\u8f38\u5b50\u4eac", this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testIsoFileDefaults(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = TestResources.getFile("/test-file-iso8859-1.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, ISO_8859_1);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testIsoFileManyWindowsBreaksSmallBlockSize2VerifyBlockSpanningNewLines(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = TestResources.getFile("/test-file-iso8859-1-shortlines-win-linebr.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, ISO_8859_1);
        for (int i = 3; i > 0; --i) {
            for (int j = 1; j <= 3; ++j) {
                ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("", this.reversedLinesFileReader.readLine());
            }
            ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("" + i, this.reversedLinesFileReader.readLine());
        }
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testShiftJISFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileShiftJIS = TestResources.getFile("/test-file-shiftjis.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileShiftJIS, testParamBlockSize, "Shift_JIS");
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_SHIFT_JIS2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_SHIFT_JIS1, this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUnsupportedEncodingBig5(int testParamBlockSize) throws URISyntaxException {
        File testFileEncodingBig5 = TestResources.getFile("/test-file-empty.bin");
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEncodingBig5, testParamBlockSize, "Big5").close());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUnsupportedEncodingUTF16(int testParamBlockSize) throws URISyntaxException {
        File testFileEmpty = TestResources.getFile("/test-file-empty.bin");
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEmpty, testParamBlockSize, StandardCharsets.UTF_16.name()).close());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUTF16BEFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileUTF16BE = TestResources.getFile("/test-file-utf16be.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUTF16BE, testParamBlockSize, StandardCharsets.UTF_16BE.name());
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUTF16LEFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileUTF16LE = TestResources.getFile("/test-file-utf16le.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUTF16LE, testParamBlockSize, StandardCharsets.UTF_16LE.name());
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUTF8File(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = TestResources.getFile("/test-file-utf8.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUTF8FileCRBreaks(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = TestResources.getFile("/test-file-utf8-cr-only.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUTF8FileWindowsBreaks(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileIso = TestResources.getFile("/test-file-utf8-win-linebr.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testUTF8FileWindowsBreaksSmallBlockSize2VerifyBlockSpanningNewLines(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileUtf8 = TestResources.getFile("/test-file-utf8-win-linebr.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileUtf8, testParamBlockSize, UTF_8);
        this.assertFileWithShrinkingTestLines(this.reversedLinesFileReader);
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testWindows31jFile(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFileWindows31J = TestResources.getFile("/test-file-windows-31j.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileWindows31J, testParamBlockSize, "windows-31j");
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("\u660e\u8f38\u5b50\u4eac", this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_WINDOWS_31J_1, this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testxWindows949File(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFilexWindows949 = TestResources.getFile("/test-file-x-windows-949.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFilexWindows949, testParamBlockSize, "x-windows-949");
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_X_WINDOWS_949_2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_X_WINDOWS_949_1, this.reversedLinesFileReader.readLine());
    }

    @ParameterizedTest(name="BlockSize={0}")
    @MethodSource(value={"blockSizes"})
    void testxWindows950File(int testParamBlockSize) throws URISyntaxException, IOException {
        File testFilexWindows950 = TestResources.getFile("/test-file-x-windows-950.bin");
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFilexWindows950, testParamBlockSize, "x-windows-950");
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks(TEST_LINE_X_WINDOWS_950_2, this.reversedLinesFileReader.readLine());
        ReversedLinesFileReaderParamBlockSizeTest.assertEqualsAndNoLineBreaks("\u660e\u8f38\u5b50\u4eac", this.reversedLinesFileReader.readLine());
    }
}

