/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.test.ThrowOnCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HexDumpTest {
    HexDumpTest() {
    }

    @Test
    void testDumpAppendable() throws IOException {
        byte[] testArray = new byte[256];
        for (int j = 0; j < 256; ++j) {
            testArray[j] = (byte)j;
        }
        StringBuilder out = new StringBuilder();
        HexDump.dump((byte[])testArray, (Appendable)out);
        Assertions.assertEquals((Object)("00000000 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F ................" + System.lineSeparator() + "00000010 10 11 12 13 14 15 16 17 18 19 1A 1B 1C 1D 1E 1F ................" + System.lineSeparator() + "00000020 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F  !\"#$%&'()*+,-./" + System.lineSeparator() + "00000030 30 31 32 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 0123456789:;<=>?" + System.lineSeparator() + "00000040 40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F @ABCDEFGHIJKLMNO" + System.lineSeparator() + "00000050 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F PQRSTUVWXYZ[\\]^_" + System.lineSeparator() + "00000060 60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F `abcdefghijklmno" + System.lineSeparator() + "00000070 70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E 7F pqrstuvwxyz{|}~." + System.lineSeparator() + "00000080 80 81 82 83 84 85 86 87 88 89 8A 8B 8C 8D 8E 8F ................" + System.lineSeparator() + "00000090 90 91 92 93 94 95 96 97 98 99 9A 9B 9C 9D 9E 9F ................" + System.lineSeparator() + "000000A0 A0 A1 A2 A3 A4 A5 A6 A7 A8 A9 AA AB AC AD AE AF ................" + System.lineSeparator() + "000000B0 B0 B1 B2 B3 B4 B5 B6 B7 B8 B9 BA BB BC BD BE BF ................" + System.lineSeparator() + "000000C0 C0 C1 C2 C3 C4 C5 C6 C7 C8 C9 CA CB CC CD CE CF ................" + System.lineSeparator() + "000000D0 D0 D1 D2 D3 D4 D5 D6 D7 D8 D9 DA DB DC DD DE DF ................" + System.lineSeparator() + "000000E0 E0 E1 E2 E3 E4 E5 E6 E7 E8 E9 EA EB EC ED EE EF ................" + System.lineSeparator() + "000000F0 F0 F1 F2 F3 F4 F5 F6 F7 F8 F9 FA FB FC FD FE FF ................" + System.lineSeparator()), (Object)out.toString());
        out = new StringBuilder();
        HexDump.dump((byte[])testArray, (long)0x10000000L, (Appendable)out, (int)40, (int)32);
        Assertions.assertEquals((Object)("10000028 28 29 2A 2B 2C 2D 2E 2F 30 31 32 33 34 35 36 37 ()*+,-./01234567" + System.lineSeparator() + "10000038 38 39 3A 3B 3C 3D 3E 3F 40 41 42 43 44 45 46 47 89:;<=>?@ABCDEFG" + System.lineSeparator()), (Object)out.toString());
        out = new StringBuilder();
        HexDump.dump((byte[])testArray, (long)0L, (Appendable)out, (int)64, (int)24);
        Assertions.assertEquals((Object)("00000040 40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F @ABCDEFGHIJKLMNO" + System.lineSeparator() + "00000050 50 51 52 53 54 55 56 57                         PQRSTUVW" + System.lineSeparator()), (Object)out.toString());
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> HexDump.dump((byte[])testArray, (long)0x10000000L, (Appendable)new StringBuilder(), (int)-1, (int)testArray.length));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> HexDump.dump((byte[])testArray, (long)0x10000000L, (Appendable)new StringBuilder(), (int)testArray.length, (int)testArray.length));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> HexDump.dump((byte[])testArray, (long)0L, (Appendable)new StringBuilder(), (int)0, (int)-1));
        Exception exception = (Exception)Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> HexDump.dump((byte[])testArray, (long)0L, (Appendable)new StringBuilder(), (int)1, (int)testArray.length));
        Assertions.assertEquals((Object)"Range [1, 1 + 256) out of bounds for length 256", (Object)exception.getMessage());
        Assertions.assertThrows(NullPointerException.class, () -> HexDump.dump((byte[])testArray, (long)0x10000000L, null, (int)0, (int)testArray.length));
    }

    @Test
    void testDumpOutputStream() throws IOException {
        int k;
        int offset;
        int j;
        byte[] testArray = new byte[256];
        for (int j2 = 0; j2 < 256; ++j2) {
            testArray[j2] = (byte)j2;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)0L, (OutputStream)stream, (int)0);
        byte[] outputArray = new byte[16 * (73 + System.lineSeparator().length())];
        for (int j3 = 0; j3 < 16; ++j3) {
            int k2;
            int offset2 = (73 + System.lineSeparator().length()) * j3;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 48;
            outputArray[offset2++] = (byte)this.toHex(j3);
            outputArray[offset2++] = 48;
            outputArray[offset2++] = 32;
            for (k2 = 0; k2 < 16; ++k2) {
                outputArray[offset2++] = (byte)this.toHex(j3);
                outputArray[offset2++] = (byte)this.toHex(k2);
                outputArray[offset2++] = 32;
            }
            for (k2 = 0; k2 < 16; ++k2) {
                outputArray[offset2++] = (byte)this.toAscii(j3 * 16 + k2);
            }
            System.arraycopy(System.lineSeparator().getBytes(), 0, outputArray, offset2, System.lineSeparator().getBytes().length);
        }
        byte[] actualOutput = stream.toByteArray();
        Assertions.assertEquals((int)outputArray.length, (int)actualOutput.length, (String)"array size mismatch");
        for (j = 0; j < outputArray.length; ++j) {
            Assertions.assertEquals((byte)outputArray[j], (byte)actualOutput[j], (String)("array[ " + j + "] mismatch"));
        }
        stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)stream, (int)0);
        outputArray = new byte[16 * (73 + System.lineSeparator().length())];
        for (j = 0; j < 16; ++j) {
            offset = (73 + System.lineSeparator().length()) * j;
            outputArray[offset++] = 49;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = (byte)this.toHex(j);
            outputArray[offset++] = 48;
            outputArray[offset++] = 32;
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toHex(j);
                outputArray[offset++] = (byte)this.toHex(k);
                outputArray[offset++] = 32;
            }
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toAscii(j * 16 + k);
            }
            System.arraycopy(System.lineSeparator().getBytes(), 0, outputArray, offset, System.lineSeparator().getBytes().length);
        }
        actualOutput = stream.toByteArray();
        Assertions.assertEquals((int)outputArray.length, (int)actualOutput.length, (String)"array size mismatch");
        for (j = 0; j < outputArray.length; ++j) {
            Assertions.assertEquals((byte)outputArray[j], (byte)actualOutput[j], (String)("array[ " + j + "] mismatch"));
        }
        stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)-16777216L, (OutputStream)stream, (int)0);
        outputArray = new byte[16 * (73 + System.lineSeparator().length())];
        for (j = 0; j < 16; ++j) {
            offset = (73 + System.lineSeparator().length()) * j;
            outputArray[offset++] = 70;
            outputArray[offset++] = 70;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = (byte)this.toHex(j);
            outputArray[offset++] = 48;
            outputArray[offset++] = 32;
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toHex(j);
                outputArray[offset++] = (byte)this.toHex(k);
                outputArray[offset++] = 32;
            }
            for (k = 0; k < 16; ++k) {
                outputArray[offset++] = (byte)this.toAscii(j * 16 + k);
            }
            System.arraycopy(System.lineSeparator().getBytes(), 0, outputArray, offset, System.lineSeparator().getBytes().length);
        }
        actualOutput = stream.toByteArray();
        Assertions.assertEquals((int)outputArray.length, (int)actualOutput.length, (String)"array size mismatch");
        for (j = 0; j < outputArray.length; ++j) {
            Assertions.assertEquals((byte)outputArray[j], (byte)actualOutput[j], (String)("array[ " + j + "] mismatch"));
        }
        stream = new ByteArrayOutputStream();
        HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)stream, (int)129);
        outputArray = new byte[8 * (73 + System.lineSeparator().length()) - 1];
        for (j = 0; j < 8; ++j) {
            int index;
            offset = (73 + System.lineSeparator().length()) * j;
            outputArray[offset++] = 49;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = 48;
            outputArray[offset++] = (byte)this.toHex(j + 8);
            outputArray[offset++] = 49;
            outputArray[offset++] = 32;
            for (k = 0; k < 16; ++k) {
                index = 129 + j * 16 + k;
                if (index < 256) {
                    outputArray[offset++] = (byte)this.toHex(index / 16);
                    outputArray[offset++] = (byte)this.toHex(index);
                } else {
                    outputArray[offset++] = 32;
                    outputArray[offset++] = 32;
                }
                outputArray[offset++] = 32;
            }
            for (k = 0; k < 16; ++k) {
                index = 129 + j * 16 + k;
                if (index >= 256) continue;
                outputArray[offset++] = (byte)this.toAscii(index);
            }
            System.arraycopy(System.lineSeparator().getBytes(), 0, outputArray, offset, System.lineSeparator().getBytes().length);
        }
        actualOutput = stream.toByteArray();
        Assertions.assertEquals((int)outputArray.length, (int)actualOutput.length, (String)"array size mismatch");
        for (j = 0; j < outputArray.length; ++j) {
            Assertions.assertEquals((byte)outputArray[j], (byte)actualOutput[j], (String)("array[ " + j + "] mismatch"));
        }
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)new ByteArrayOutputStream(), (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> HexDump.dump((byte[])testArray, (long)0x10000000L, (OutputStream)new ByteArrayOutputStream(), (int)testArray.length));
        Assertions.assertThrows(NullPointerException.class, () -> HexDump.dump((byte[])testArray, (long)0x10000000L, null, (int)0));
        HexDump.dump((byte[])testArray, (long)0L, (OutputStream)((Object)new ThrowOnCloseOutputStream((OutputStream)new ByteArrayOutputStream())), (int)0);
    }

    private char toAscii(int c) {
        char rval = '.';
        if (c >= 32 && c <= 126) {
            rval = (char)c;
        }
        return rval;
    }

    private char toHex(int n) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        return hexChars[n % 16];
    }
}

